/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.solr.schema.SortableFloatFieldSource;

public class StrFieldSource
extends FieldCacheSource {
    private static int hcode = SortableFloatFieldSource.class.hashCode();

    public StrFieldSource(String field) {
        super(field);
    }

    public String description() {
        return "str(" + this.field + ')';
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        return new DocTermsIndexDocValues((ValueSource)this, readerContext, this.field){

            protected String toTerm(String readableValue) {
                return readableValue;
            }

            public int ordVal(int doc) {
                return this.termsIndex.getOrd(doc);
            }

            public int numOrd() {
                return this.termsIndex.numOrd();
            }

            public Object objectVal(int doc) {
                return this.strVal(doc);
            }

            public String toString(int doc) {
                return StrFieldSource.this.description() + '=' + this.strVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof StrFieldSource && super.equals(o);
    }

    public int hashCode() {
        return hcode + super.hashCode();
    }
}

