/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.requestfactory;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.Grouping;
import org.apache.solr.search.grouping.distributed.ShardRequestFactory;

public class TopGroupsShardRequestFactory
implements ShardRequestFactory {
    public static final String GROUP_NULL_VALUE = "\u0001";

    @Override
    public ShardRequest[] constructRequest(ResponseBuilder rb) {
        boolean containsGroupByQuery;
        boolean bl = containsGroupByQuery = rb.getGroupingSpec().getQueries().length > 0;
        if ((rb.getQueryCommand().getFlags() & 0x40000000) != 0 || containsGroupByQuery) {
            return this.createRequestForAllShards(rb);
        }
        return this.createRequestForSpecificShards(rb);
    }

    private ShardRequest[] createRequestForSpecificShards(ResponseBuilder rb) {
        HashSet<String> uniqueShards = new HashSet<String>();
        for (String command : rb.searchGroupToShards.keySet()) {
            Map<SearchGroup<BytesRef>, Set<String>> groupsToShard = rb.searchGroupToShards.get(command);
            for (Set<String> shards : groupsToShard.values()) {
                uniqueShards.addAll(shards);
            }
        }
        return this.createRequest(rb, uniqueShards.toArray(new String[uniqueShards.size()]));
    }

    private ShardRequest[] createRequestForAllShards(ResponseBuilder rb) {
        return this.createRequest(rb, ShardRequest.ALL_SHARDS);
    }

    private ShardRequest[] createRequest(ResponseBuilder rb, String[] shards) {
        ShardRequest sreq = new ShardRequest();
        sreq.shards = shards;
        sreq.purpose = 4;
        sreq.params = new ModifiableSolrParams(rb.req.getParams());
        Grouping.Format responseFormat = rb.getGroupingSpec().getResponseFormat();
        if (responseFormat == Grouping.Format.simple || rb.getGroupingSpec().isMain()) {
            sreq.params.remove("group.offset");
        }
        sreq.params.remove("shards");
        if (rb.shards_start > -1) {
            sreq.params.set("start", rb.shards_start);
        } else {
            sreq.params.set("start", new String[]{"0"});
        }
        if (rb.shards_rows > -1) {
            sreq.params.set("rows", rb.shards_rows);
        } else {
            sreq.params.set("rows", rb.getSortSpec().getOffset() + rb.getSortSpec().getCount());
        }
        sreq.params.set("group.distributed.second", new String[]{"true"});
        for (Map.Entry<String, Collection<SearchGroup<BytesRef>>> entry : rb.mergedSearchGroups.entrySet()) {
            for (SearchGroup<BytesRef> searchGroup : entry.getValue()) {
                String groupValue;
                if (searchGroup.groupValue != null) {
                    String rawGroupValue = ((BytesRef)searchGroup.groupValue).utf8ToString();
                    FieldType fieldType = rb.req.getSearcher().getSchema().getField(entry.getKey()).getType();
                    groupValue = fieldType.indexedToReadable(rawGroupValue);
                } else {
                    groupValue = GROUP_NULL_VALUE;
                }
                sreq.params.add("group.topgroups." + entry.getKey(), new String[]{groupValue});
            }
        }
        if ((rb.getFieldFlags() & 1) != 0 || rb.getSortSpec().includesScore()) {
            sreq.params.set("fl", new String[]{rb.req.getSchema().getUniqueKeyField().getName() + ",score"});
        } else {
            sreq.params.set("fl", new String[]{rb.req.getSchema().getUniqueKeyField().getName()});
        }
        int origTimeAllowed = sreq.params.getInt("timeAllowed", -1);
        if (origTimeAllowed > 0) {
            sreq.params.set("timeAllowed", Math.max(1, origTimeAllowed - rb.firstPhaseElapsedTime));
        }
        return new ShardRequest[]{sreq};
    }
}

