/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Date;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.mutable.MutableValueDate;
import org.apache.lucene.util.mutable.MutableValueLong;
import org.apache.solr.schema.TrieField;

class TrieDateFieldSource
extends LongFieldSource {
    public TrieDateFieldSource(String field, FieldCache.LongParser parser) {
        super(field, parser);
    }

    public String description() {
        return "date(" + this.field + ')';
    }

    protected MutableValueLong newMutableValueLong() {
        return new MutableValueDate();
    }

    public Object longToObject(long val) {
        return new Date(val);
    }

    public long externalToLong(String extVal) {
        return TrieField.dateField.parseMath(null, extVal).getTime();
    }
}

