/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.command;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.BehaviorCommandComponentSetup;
import org.seasar.dbflute.bhv.core.execution.OutsideSqlExecuteExecution;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.s2dao.extension.TnRelationRowCreatorExtension;
import org.seasar.dbflute.s2dao.extension.TnRowCreatorExtension;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaDataFactory;
import org.seasar.dbflute.s2dao.rshandler.TnBeanCursorResultSetHandler;
import org.seasar.dbflute.s2dao.rshandler.TnBeanListResultSetHandler;
import org.seasar.dbflute.s2dao.rshandler.TnScalarDynamicResultSetHandler;
import org.seasar.dbflute.s2dao.rshandler.TnScalarListResultSetHandler;
import org.seasar.dbflute.s2dao.rshandler.TnScalarResultSetHandler;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

public abstract class AbstractBehaviorCommand<RESULT>
implements BehaviorCommand<RESULT>,
BehaviorCommandComponentSetup {
    protected String _tableDbName;
    protected boolean _initializeOnly;
    protected DataSource _dataSource;
    protected StatementFactory _statementFactory;
    protected TnBeanMetaDataFactory _beanMetaDataFactory;
    protected String _sqlFileEncoding;

    protected OutsideSqlExecuteExecution createOutsideSqlExecuteExecution(Object pmbTypeObj, String sql) {
        Map<String, Class<?>> argNameTypeMap = this.createBeanArgNameTypeMap(pmbTypeObj);
        return this.newOutsideSqlExecuteExecution(argNameTypeMap, sql);
    }

    protected OutsideSqlExecuteExecution newOutsideSqlExecuteExecution(Map<String, Class<?>> argNameTypeMap, String sql) {
        return new OutsideSqlExecuteExecution(this._dataSource, this._statementFactory, argNameTypeMap, sql);
    }

    protected Map<String, Class<?>> createBeanArgNameTypeMap(Object pmbTypeObj) {
        Map<String, Class<?>> argNameTypeMap = this.newArgNameTypeMap();
        if (pmbTypeObj == null) {
            return argNameTypeMap;
        }
        Class<?> pmbType = pmbTypeObj instanceof Class ? (Class<?>)pmbTypeObj : pmbTypeObj.getClass();
        argNameTypeMap.put("pmb", pmbType);
        return argNameTypeMap;
    }

    protected Map<String, Class<?>> newArgNameTypeMap() {
        return new LinkedHashMap();
    }

    protected TnResultSetHandler createBeanListResultSetHandler(TnBeanMetaData bmd) {
        TnRowCreatorExtension rowCreator = this.createRowCreator(bmd);
        TnRelationRowCreatorExtension relationRowCreator = this.createRelationRowCreator(bmd);
        return new TnBeanListResultSetHandler(bmd, rowCreator, relationRowCreator);
    }

    protected TnResultSetHandler createBeanCursorResultSetHandler(TnBeanMetaData bmd) {
        TnRowCreatorExtension rowCreator = this.createRowCreator(bmd);
        TnRelationRowCreatorExtension relationRowCreator = this.createRelationRowCreator(bmd);
        return new TnBeanCursorResultSetHandler(bmd, rowCreator, relationRowCreator);
    }

    protected TnResultSetHandler createScalarResultSetHandler(Class<?> objectType) {
        ValueType valueType = TnValueTypes.getValueType(objectType);
        return new TnScalarResultSetHandler(valueType);
    }

    protected TnResultSetHandler createScalarListResultSetHandler(Class<?> objectType) {
        ValueType valueType = TnValueTypes.getValueType(objectType);
        return this.createScalarListResultSetHandler(valueType);
    }

    protected TnResultSetHandler createDynamicScalarResultSetHandler(Class<?> objectType) {
        ValueType valueType = TnValueTypes.getValueType(objectType);
        return new TnScalarDynamicResultSetHandler(valueType);
    }

    protected TnResultSetHandler createScalarListResultSetHandler(ValueType valueType) {
        return new TnScalarListResultSetHandler(valueType);
    }

    protected TnRowCreatorExtension createRowCreator(TnBeanMetaData bmd) {
        Class<?> clazz = bmd != null ? bmd.getBeanClass() : null;
        return TnRowCreatorExtension.createRowCreator(clazz);
    }

    protected TnRelationRowCreatorExtension createRelationRowCreator(TnBeanMetaData bmd) {
        return TnRelationRowCreatorExtension.createRelationRowCreator();
    }

    protected void assertBasicProperty(String methodName) {
        if (this._tableDbName == null) {
            throw new IllegalStateException(this.buildAssertMessage("_tableDbName", methodName));
        }
    }

    protected void assertComponentProperty(String methodName) {
        if (this._dataSource == null) {
            throw new IllegalStateException(this.buildAssertMessage("_dataSource", methodName));
        }
        if (this._statementFactory == null) {
            throw new IllegalStateException(this.buildAssertMessage("_statementFactory", methodName));
        }
        if (this._beanMetaDataFactory == null) {
            throw new IllegalStateException(this.buildAssertMessage("_beanMetaDataFactory", methodName));
        }
        if (this._sqlFileEncoding == null) {
            throw new IllegalStateException(this.buildAssertMessage("_sqlFileEncoding", methodName));
        }
    }

    protected String buildAssertMessage(String propertyName, String methodName) {
        String msg = "The property '" + Srl.ltrim(propertyName, "_") + "' should not be null";
        msg = msg + " when you call " + methodName + "().";
        throw new IllegalStateException(msg);
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this.buildSqlExecutionKey() + "}";
    }

    @Override
    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    public void setInitializeOnly(boolean initializeOnly) {
        this._initializeOnly = initializeOnly;
    }

    @Override
    public boolean isInitializeOnly() {
        return this._initializeOnly;
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    @Override
    public void setStatementFactory(StatementFactory statementFactory) {
        this._statementFactory = statementFactory;
    }

    @Override
    public void setBeanMetaDataFactory(TnBeanMetaDataFactory beanMetaDataFactory) {
        this._beanMetaDataFactory = beanMetaDataFactory;
    }

    @Override
    public void setSqlFileEncoding(String sqlFileEncoding) {
        this._sqlFileEncoding = sqlFileEncoding;
    }
}

