/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.chelper;

import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

public class HpSpecifiedColumn {
    protected final String _tableAliasName;
    protected final ColumnInfo _columnInfo;
    protected final ConditionBean _baseCB;
    protected final String _columnDirectName;
    protected final boolean _derived;
    protected HpSpecifiedColumn _mappedSpecifiedColumn;
    protected String _mappedDerivedAlias;
    protected String _onQueryName;

    public HpSpecifiedColumn(String tableAliasName, ColumnInfo columnInfo, ConditionBean baseCB) {
        this.assertColumnInfo(tableAliasName, columnInfo);
        this.assertBaseCB(tableAliasName, baseCB);
        this._tableAliasName = tableAliasName;
        this._columnInfo = columnInfo;
        this._baseCB = baseCB;
        this._columnDirectName = null;
        this._derived = false;
    }

    public HpSpecifiedColumn(String tableAliasName, ColumnInfo columnInfo, ConditionBean baseCB, String columnDirectName, boolean derived) {
        this.assertColumnInfo(tableAliasName, columnInfo);
        this.assertBaseCB(tableAliasName, baseCB);
        this._tableAliasName = tableAliasName;
        this._columnInfo = columnInfo;
        this._baseCB = baseCB;
        this._columnDirectName = columnDirectName;
        this._derived = derived;
    }

    protected void assertColumnInfo(String tableAliasName, ColumnInfo columnInfo) {
        if (columnInfo == null) {
            String msg = "The argument 'columnInfo' should not be null: tableAliasName=" + tableAliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertBaseCB(String tableAliasName, ConditionBean baseCB) {
        if (baseCB == null) {
            String msg = "The argument 'baseCB' should not be null: tableAliasName=" + tableAliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    public boolean isDreamCruiseTicket() {
        return this._baseCB.xisDreamCruiseShip();
    }

    public void setupSelectDreamCruiseJourneyLogBookIfUnionExists() {
        if (!this.isDreamCruiseTicket()) {
            String msg = "This method is only allowed at Dream Cruise.";
            throw new IllegalConditionBeanOperationException(msg);
        }
        this._baseCB.xsetupSelectDreamCruiseJourneyLogBookIfUnionExists();
    }

    public String getColumnDbName() {
        return this._columnInfo.getColumnDbName();
    }

    public ColumnSqlName toColumnSqlName() {
        return this._columnDirectName != null ? new ColumnSqlName(this._columnDirectName) : this._columnInfo.getColumnSqlName();
    }

    public ColumnRealName toColumnRealName() {
        return ColumnRealName.create(this._tableAliasName, this.toColumnSqlName());
    }

    public void mappedFrom(HpSpecifiedColumn mappedSpecifiedInfo) {
        this._mappedSpecifiedColumn = mappedSpecifiedInfo;
    }

    public void mappedFromDerived(String mappedDerivedAlias) {
        this._mappedDerivedAlias = mappedDerivedAlias;
    }

    public String getValidMappedOnQueryName() {
        if (this._mappedSpecifiedColumn != null) {
            return this._mappedSpecifiedColumn.getOnQueryName();
        }
        if (this._mappedDerivedAlias != null) {
            return this._mappedDerivedAlias;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this._tableAliasName).append(", ");
        sb.append(this._columnDirectName != null ? this._columnDirectName + ", " : "");
        sb.append(this._columnInfo).append("}");
        return sb.toString();
    }

    public String getTableAliasName() {
        return this._tableAliasName;
    }

    public ColumnInfo getColumnInfo() {
        return this._columnInfo;
    }

    public String getColumnDirectName() {
        return this._columnDirectName;
    }

    public boolean isDerived() {
        return this._derived;
    }

    public HpSpecifiedColumn getMappedSpecifiedInfo() {
        return this._mappedSpecifiedColumn;
    }

    public String getMappedAliasName() {
        return this._mappedDerivedAlias;
    }

    public String getOnQueryName() {
        return this._onQueryName;
    }

    public void setOnQueryName(String onQueryName) {
        this._onQueryName = onQueryName;
    }
}

