/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta.info;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.RelationInfo;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.Srl;

public class ForeignInfo
implements RelationInfo {
    protected final String _constraintName;
    protected final String _foreignPropertyName;
    protected final DBMeta _localDBMeta;
    protected final DBMeta _foreignDBMeta;
    protected final Map<ColumnInfo, ColumnInfo> _localForeignColumnInfoMap;
    protected final Map<ColumnInfo, ColumnInfo> _foreignLocalColumnInfoMap;
    protected final int _relationNo;
    protected final boolean _oneToOne;
    protected final boolean _bizOneToOne;
    protected final boolean _referrerAsOne;
    protected final boolean _additionalFK;
    protected final String _fixedCondition;
    protected final boolean _fixedInline;
    protected final String _reversePropertyName;
    protected final Method _readMethod;
    protected final Method _writeMethod;

    public ForeignInfo(String constraintName, String foreignPropertyName, DBMeta localDBMeta, DBMeta foreignDBMeta, Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap, int relationNo, boolean oneToOne, boolean bizOneToOne, boolean referrerAsOne, boolean additionalFK, String fixedCondition, boolean fixedInline, String reversePropertyName) {
        this.assertObjectNotNull("constraintName", constraintName);
        this.assertObjectNotNull("foreignPropertyName", foreignPropertyName);
        this.assertObjectNotNull("localDBMeta", localDBMeta);
        this.assertObjectNotNull("foreignDBMeta", foreignDBMeta);
        this.assertObjectNotNull("localForeignColumnInfoMap", localForeignColumnInfoMap);
        this._constraintName = constraintName;
        this._foreignPropertyName = foreignPropertyName;
        this._localDBMeta = localDBMeta;
        this._foreignDBMeta = foreignDBMeta;
        this._localForeignColumnInfoMap = localForeignColumnInfoMap;
        Set<ColumnInfo> keySet = localForeignColumnInfoMap.keySet();
        this._foreignLocalColumnInfoMap = new LinkedHashMap<ColumnInfo, ColumnInfo>();
        for (ColumnInfo key : keySet) {
            ColumnInfo value = localForeignColumnInfoMap.get(key);
            this._foreignLocalColumnInfoMap.put(value, key);
        }
        this._relationNo = relationNo;
        this._oneToOne = oneToOne;
        this._bizOneToOne = bizOneToOne;
        this._referrerAsOne = referrerAsOne;
        this._additionalFK = additionalFK;
        this._fixedCondition = fixedCondition;
        this._fixedInline = fixedInline;
        this._reversePropertyName = reversePropertyName;
        this._readMethod = this.findReadMethod();
        this._writeMethod = this.findWriteMethod();
    }

    public boolean containsLocalColumn(ColumnInfo localColumn) {
        return this.doContainsLocalColumn(localColumn.getColumnDbName());
    }

    protected boolean doContainsLocalColumn(String columnName) {
        for (ColumnInfo columnInfo : this._localForeignColumnInfoMap.keySet()) {
            if (!columnInfo.getColumnDbName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsForeignColumn(ColumnInfo foreignColumn) {
        return this.doContainsForeignColumn(foreignColumn.getColumnDbName());
    }

    protected boolean doContainsForeignColumn(String columnName) {
        for (ColumnInfo columnInfo : this._foreignLocalColumnInfoMap.keySet()) {
            if (!columnInfo.getColumnDbName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public ColumnInfo findLocalByForeign(String foreignColumnDbName) {
        ColumnInfo keyColumnInfo = this._foreignDBMeta.findColumnInfo(foreignColumnDbName);
        ColumnInfo resultColumnInfo = this._foreignLocalColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by foreignColumnDbName in foreignLocalColumnInfoMap:";
            msg = msg + " foreignColumnDbName=" + foreignColumnDbName;
            msg = msg + " foreignLocalColumnInfoMap=" + this._foreignLocalColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public ColumnInfo findForeignByLocal(String localColumnDbName) {
        ColumnInfo keyColumnInfo = this._localDBMeta.findColumnInfo(localColumnDbName);
        ColumnInfo resultColumnInfo = this._localForeignColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by localColumnDbName in localForeignColumnInfoMap:";
            msg = msg + " localColumnDbName=" + localColumnDbName;
            msg = msg + " localForeignColumnInfoMap=" + this._localForeignColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public <PROPERTY extends Entity> PROPERTY read(Entity localEntity) {
        return (PROPERTY)((Entity)this.invokeMethod(this.getReadMethod(), localEntity, new Object[0]));
    }

    public Method getReadMethod() {
        return this._readMethod;
    }

    public void write(Entity localEntity, Entity foreignEntity) {
        this.invokeMethod(this.getWriteMethod(), localEntity, new Object[]{foreignEntity});
    }

    public Method getWriteMethod() {
        return this._writeMethod;
    }

    protected Method findReadMethod() {
        String methodName;
        Class<? extends Entity> localType = this._localDBMeta.getEntityType();
        Method method = this.findMethod(localType, methodName = this.buildAccessorName("get"), new Class[0]);
        if (method == null) {
            String msg = "Not found the method by the name: " + methodName;
            throw new IllegalStateException(msg);
        }
        return method;
    }

    protected Method findWriteMethod() {
        Class<? extends Entity> localType = this._localDBMeta.getEntityType();
        Class<? extends Entity> foreignType = this._foreignDBMeta.getEntityType();
        String methodName = this.buildAccessorName("set");
        Method method = this.findMethod(localType, methodName, new Class[]{foreignType});
        if (method == null) {
            String msg = "Not found the method by the name and type: " + methodName + ", " + foreignType;
            throw new IllegalStateException(msg);
        }
        return method;
    }

    protected String buildAccessorName(String prefix) {
        return prefix + this.initCap(this._foreignPropertyName);
    }

    protected Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        return DfReflectionUtil.getAccessibleMethod(clazz, methodName, argTypes);
    }

    protected Object invokeMethod(Method method, Object target, Object[] args) {
        return DfReflectionUtil.invoke(method, target, args);
    }

    @Override
    public String getRelationPropertyName() {
        return this.getForeignPropertyName();
    }

    @Override
    public DBMeta getTargetDBMeta() {
        return this.getForeignDBMeta();
    }

    @Override
    public Map<ColumnInfo, ColumnInfo> getLocalTargetColumnInfoMap() {
        return this.getLocalForeignColumnInfoMap();
    }

    @Override
    public boolean isReferrer() {
        return false;
    }

    protected String initCap(String name) {
        return Srl.initCap(name);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this._foreignPropertyName.hashCode() + this._localDBMeta.hashCode() + this._foreignDBMeta.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ForeignInfo)) {
            return false;
        }
        ForeignInfo target = (ForeignInfo)obj;
        if (!this._foreignPropertyName.equals(target.getForeignPropertyName())) {
            return false;
        }
        if (!this._localDBMeta.equals(target.getLocalDBMeta())) {
            return false;
        }
        return this._foreignDBMeta.equals(target.getForeignDBMeta());
    }

    public String toString() {
        return this._localDBMeta.getTableDbName() + "." + this._foreignPropertyName + "->" + this._foreignDBMeta.getTableDbName();
    }

    @Override
    public String getConstraintName() {
        return this._constraintName;
    }

    public String getForeignPropertyName() {
        return this._foreignPropertyName;
    }

    @Override
    public DBMeta getLocalDBMeta() {
        return this._localDBMeta;
    }

    public DBMeta getForeignDBMeta() {
        return this._foreignDBMeta;
    }

    public Map<ColumnInfo, ColumnInfo> getLocalForeignColumnInfoMap() {
        return new LinkedHashMap<ColumnInfo, ColumnInfo>(this._localForeignColumnInfoMap);
    }

    public Map<ColumnInfo, ColumnInfo> getForeignLocalColumnInfoMap() {
        return new LinkedHashMap<ColumnInfo, ColumnInfo>(this._foreignLocalColumnInfoMap);
    }

    public int getRelationNo() {
        return this._relationNo;
    }

    @Override
    public boolean isOneToOne() {
        return this._oneToOne;
    }

    public boolean isBizOneToOne() {
        return this._bizOneToOne;
    }

    public boolean isReferrerAsOne() {
        return this._referrerAsOne;
    }

    public boolean isAdditionalFK() {
        return this._additionalFK;
    }

    public String getFixedCondition() {
        return this._fixedCondition;
    }

    public boolean isFixedInline() {
        return this._fixedInline;
    }

    @Override
    public RelationInfo getReverseRelation() {
        return this._reversePropertyName != null ? this._foreignDBMeta.findRelationInfo(this._reversePropertyName) : null;
    }

    public boolean isPureFK() {
        return !this._additionalFK && !this._referrerAsOne;
    }

    public boolean isNotNullFKColumn() {
        for (Map.Entry<ColumnInfo, ColumnInfo> entry : this.getLocalForeignColumnInfoMap().entrySet()) {
            ColumnInfo localColumnInfo = entry.getKey();
            if (localColumnInfo.isNotNull()) continue;
            return false;
        }
        return true;
    }
}

