/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.token.file;

import java.util.List;
import org.seasar.dbflute.helper.token.file.FileMakingHeaderInfo;

public class FileMakingOption {
    protected String _encoding;
    protected String _delimiter;
    protected String _lineSeparator;
    protected boolean _quoteMinimally;
    protected FileMakingHeaderInfo _headerInfo;

    public FileMakingOption delimitateByComma() {
        this._delimiter = ",";
        return this;
    }

    public FileMakingOption delimitateByTab() {
        this._delimiter = "\t";
        return this;
    }

    public FileMakingOption encodeAsUTF8() {
        this._encoding = "UTF-8";
        return this;
    }

    public FileMakingOption encodeAsWindows31J() {
        this._encoding = "Windows-31J";
        return this;
    }

    public FileMakingOption separateCrLf() {
        this._lineSeparator = "\r\n";
        return this;
    }

    public FileMakingOption separateLf() {
        this._lineSeparator = "\n";
        return this;
    }

    public FileMakingOption quoteMinimally() {
        this._quoteMinimally = true;
        return this;
    }

    public FileMakingOption headerInfo(List<String> columnNameList) {
        if (columnNameList == null) {
            String msg = "The argument 'columnNameList' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        FileMakingHeaderInfo headerInfo = new FileMakingHeaderInfo();
        headerInfo.acceptColumnNameList(columnNameList);
        this._headerInfo = headerInfo;
        return this;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public void setDelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    public String getLineSeparator() {
        return this._lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this._lineSeparator = lineSeparator;
    }

    public boolean isQuoteMinimally() {
        return this._quoteMinimally;
    }

    public FileMakingHeaderInfo getFileMakingHeaderInfo() {
        return this._headerInfo;
    }

    public void setFileMakingHeaderInfo(FileMakingHeaderInfo headerInfo) {
        this._headerInfo = headerInfo;
    }
}

