/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.jdbc;

import java.util.HashMap;
import java.util.Map;
import org.seasar.dbflute.exception.CharParameterShortSizeException;
import org.seasar.dbflute.util.Srl;

public class ParameterUtil {
    public static String convertEmptyToNull(String value) {
        return Srl.isEmpty(value) ? null : value;
    }

    public static String handleShortChar(String parameterName, String value, Integer size, ShortCharHandlingMode mode) {
        if (parameterName == null || parameterName.trim().length() == 0) {
            String msg = "The argument 'parameterName' should not be null or empty:";
            msg = msg + " value=" + value + " size=" + size + " mode=" + (Object)((Object)mode);
            throw new IllegalArgumentException(msg);
        }
        if (mode == null) {
            String msg = "The argument 'mode' should not be null:";
            msg = msg + " parameterName=" + parameterName + " value=" + value + " size=" + size;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            return null;
        }
        if (size == null) {
            return value;
        }
        if (value.length() >= size) {
            return value;
        }
        if (mode.equals((Object)ShortCharHandlingMode.RFILL)) {
            return Srl.rfill(value, size);
        }
        if (mode.equals((Object)ShortCharHandlingMode.LFILL)) {
            return Srl.lfill(value, size);
        }
        if (mode.equals((Object)ShortCharHandlingMode.EXCEPTION)) {
            String msg = "The size of the parameter '" + parameterName + "' should be " + size + ":";
            msg = msg + " value=[" + value + "] size=" + value.length();
            throw new CharParameterShortSizeException(msg);
        }
        return value;
    }

    public static enum ShortCharHandlingMode {
        RFILL("R"),
        LFILL("L"),
        EXCEPTION("E"),
        NONE("N");

        private static final Map<String, ShortCharHandlingMode> _codeValueMap;
        protected final String _code;

        private ShortCharHandlingMode(String code) {
            this._code = code;
        }

        public static ShortCharHandlingMode codeOf(Object code) {
            if (code == null) {
                return null;
            }
            if (code instanceof ShortCharHandlingMode) {
                return (ShortCharHandlingMode)((Object)code);
            }
            return _codeValueMap.get(code.toString().toLowerCase());
        }

        public String code() {
            return this._code;
        }

        static {
            _codeValueMap = new HashMap<String, ShortCharHandlingMode>();
            for (ShortCharHandlingMode value : ShortCharHandlingMode.values()) {
                _codeValueMap.put(value.code().toLowerCase(), value);
            }
        }
    }
}

