/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.resource;

import java.util.HashMap;
import java.util.Map;
import org.seasar.dbflute.jdbc.SqlLogInfo;

public class InternalMapContext {
    private static final ThreadLocal<Map<String, Object>> threadLocal = new ThreadLocal();
    protected static final String KEY_BEHAVIOR_INVOKE_NAME = "df:BehaviorInvokeName";
    protected static final String KEY_CLIENT_INVOKE_NAME = "df:ClientInvokeName";
    protected static final String KEY_BYPASS_INVOKE_NAME = "df:ByPassInvokeName";
    protected static final String KEY_HOOK_SQL_LOG_INFO = "df:HookSqlLogInfo";
    protected static final String KEY_RESULT_SQL_LOG_INFO = "df:ResultSqlLogInfo";
    protected static final String KEY_SQL_BEFORE_TIME_MILLIS = "df:SqlBeforeTimeMillis";
    protected static final String KEY_SQL_AFTER_TIME_MILLIS = "df:SqlAfterTimeMillis";

    protected static void initialize() {
        if (threadLocal.get() != null) {
            return;
        }
        threadLocal.set(new HashMap());
    }

    public static Map<String, Object> getInternalMap() {
        InternalMapContext.initialize();
        return threadLocal.get();
    }

    public static Object getObject(String key) {
        InternalMapContext.initialize();
        return threadLocal.get().get(key);
    }

    public static void setObject(String key, Object value) {
        InternalMapContext.initialize();
        threadLocal.get().put(key, value);
    }

    public static boolean isExistInternalMapContextOnThread() {
        return threadLocal.get() != null;
    }

    public static void clearInternalMapContextOnThread() {
        threadLocal.set(null);
    }

    public static String getBehaviorInvokeName() {
        return (String)InternalMapContext.getObject(KEY_BEHAVIOR_INVOKE_NAME);
    }

    public static void setBehaviorInvokeName(String behaviorInvokeName) {
        InternalMapContext.setObject(KEY_BEHAVIOR_INVOKE_NAME, behaviorInvokeName);
    }

    public static String getClientInvokeName() {
        return (String)InternalMapContext.getObject(KEY_CLIENT_INVOKE_NAME);
    }

    public static void setClientInvokeName(String clientInvokeName) {
        InternalMapContext.setObject(KEY_CLIENT_INVOKE_NAME, clientInvokeName);
    }

    public static String getByPassInvokeName() {
        return (String)InternalMapContext.getObject(KEY_BYPASS_INVOKE_NAME);
    }

    public static void setByPassInvokeName(String byPassInvokeName) {
        InternalMapContext.setObject(KEY_BYPASS_INVOKE_NAME, byPassInvokeName);
    }

    public static SqlLogInfo getHookSqlLogInfo() {
        return (SqlLogInfo)InternalMapContext.getObject(KEY_HOOK_SQL_LOG_INFO);
    }

    public static void setHookSqlLogInfo(SqlLogInfo sqlLogInfo) {
        InternalMapContext.setObject(KEY_HOOK_SQL_LOG_INFO, sqlLogInfo);
    }

    public static SqlLogInfo getResultSqlLogInfo() {
        return (SqlLogInfo)InternalMapContext.getObject(KEY_RESULT_SQL_LOG_INFO);
    }

    public static void setResultSqlLogInfo(SqlLogInfo sqlLogInfo) {
        InternalMapContext.setObject(KEY_RESULT_SQL_LOG_INFO, sqlLogInfo);
    }

    public static Long getSqlBeforeTimeMillis() {
        return (Long)InternalMapContext.getObject(KEY_SQL_BEFORE_TIME_MILLIS);
    }

    public static void setSqlBeforeTimeMillis(Long sqlBeforeTimeMillis) {
        InternalMapContext.setObject(KEY_SQL_BEFORE_TIME_MILLIS, sqlBeforeTimeMillis);
    }

    public static Long getSqlAfterTimeMillis() {
        return (Long)InternalMapContext.getObject(KEY_SQL_AFTER_TIME_MILLIS);
    }

    public static void setSqlAfterTimeMillis(Long sqlAfterTimeMillis) {
        InternalMapContext.setObject(KEY_SQL_AFTER_TIME_MILLIS, sqlAfterTimeMillis);
    }
}

