/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.extension;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.helper.beans.DfPropertyAccessor;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.extension.TnRowCreatorExtension;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyMapping;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.rowcreator.impl.TnRelationRowCreationResource;
import org.seasar.dbflute.s2dao.rowcreator.impl.TnRelationRowCreatorImpl;

public class TnRelationRowCreatorExtension
extends TnRelationRowCreatorImpl {
    public static TnRelationRowCreatorExtension createRelationRowCreator() {
        return new TnRelationRowCreatorExtension();
    }

    @Override
    protected Object createRelationRow(TnRelationRowCreationResource res) throws SQLException {
        if (!res.hasPropertyCacheElement()) {
            return null;
        }
        this.setupRelationKeyValue(res);
        this.setupRelationAllValue(res);
        return res.getRow();
    }

    @Override
    protected void setupRelationKeyValue(TnRelationRowCreationResource res) {
        TnRelationPropertyType rpt = res.getRelationPropertyType();
        TnBeanMetaData bmd = rpt.getBeanMetaData();
        DBMeta dbmeta = this.findDBMeta(bmd.getBeanClass(), bmd.getTableName());
        for (int i = 0; i < rpt.getKeySize(); ++i) {
            Object value;
            String columnName = rpt.getMyKey(i) + res.getBaseSuffix();
            if (!res.containsSelectColumn(columnName)) continue;
            if (!res.hasRowInstance()) {
                Object row = dbmeta != null ? dbmeta.newEntity() : this.newRelationRow(rpt);
                res.setRow(row);
            }
            if (!res.containsRelKeyValueIfExists(columnName) || (value = res.extractRelKeyValue(columnName)) == null) continue;
            TnPropertyType mapping = bmd.getPropertyTypeByColumnName(rpt.getYourKey(i));
            this.setValue(res, mapping, dbmeta, value);
        }
    }

    protected Object createRelationRowInstance(DBMeta dbmeta) {
        if (dbmeta != null) {
            return dbmeta.newEntity();
        }
        return null;
    }

    protected DBMeta findDBMeta(Class<?> rowType, String tableName) {
        return TnRowCreatorExtension.findCachedDBMeta(rowType, tableName);
    }

    @Override
    protected void setupRelationAllValue(TnRelationRowCreationResource res) throws SQLException {
        Map<String, TnPropertyMapping> propertyCacheElement = res.extractPropertyCacheElement();
        Set<Map.Entry<String, TnPropertyMapping>> entrySet = propertyCacheElement.entrySet();
        for (Map.Entry<String, TnPropertyMapping> entry : entrySet) {
            TnPropertyMapping pt = entry.getValue();
            res.setCurrentPropertyType(pt);
            if (!this.isValidRelationPerPropertyLoop(res)) {
                res.clearRowInstance();
                return;
            }
            this.setupRelationProperty(res);
        }
        if (!this.isValidRelationAfterPropertyLoop(res)) {
            res.clearRowInstance();
            return;
        }
        res.clearValidValueCount();
        if (res.hasNextRelationProperty() && (this.hasConditionBean(res) || res.hasNextRelationLevel())) {
            this.setupNextRelationRow(res);
        }
    }

    @Override
    protected void registerRelationValue(TnRelationRowCreationResource res, String columnName) throws SQLException {
        TnPropertyMapping mapping = res.getCurrentPropertyMapping();
        Object value = null;
        if (res.containsRelKeyValueIfExists(columnName)) {
            value = res.extractRelKeyValue(columnName);
        } else {
            ValueType valueType = mapping.getValueType();
            Map<String, Integer> selectIndexMap = res.getSelectIndexMap();
            value = selectIndexMap != null ? ResourceContext.getValue(res.getResultSet(), columnName, valueType, selectIndexMap) : valueType.getValue(res.getResultSet(), columnName);
        }
        if (value != null) {
            res.incrementValidValueCount();
            DBMeta dbmeta = this.findDBMeta(res.getRow());
            this.setValue(res, mapping, dbmeta, value);
        }
    }

    protected DBMeta findDBMeta(Object row) {
        return TnRowCreatorExtension.findCachedDBMeta(row);
    }

    protected void setValue(TnRelationRowCreationResource res, TnPropertyMapping mapping, DBMeta dbmeta, Object value) {
        ColumnInfo columnInfo = mapping.getEntityColumnInfo();
        if (columnInfo != null) {
            columnInfo.write((Entity)res.getRow(), value);
        } else {
            DfPropertyAccessor accessor = mapping.getPropertyAccessor();
            accessor.setValue(res.getRow(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupPropertyCache(TnRelationRowCreationResource res) throws SQLException {
        res.initializePropertyCacheElement();
        if (this.hasConditionBean(res) && !this.hasSelectedForeignInfo(res)) {
            return;
        }
        TnBeanMetaData nextBmd = res.getRelationBeanMetaData();
        List<TnPropertyType> ptList = nextBmd.getPropertyTypeList();
        for (TnPropertyType pt : ptList) {
            res.setCurrentPropertyType(pt);
            this.setupPropertyCacheElement(res);
        }
        if (res.hasNextRelationProperty() && (this.hasConditionBean(res) || res.hasNextRelationLevel())) {
            res.backupRelationPropertyType();
            res.incrementCurrentRelationNestLevel();
            try {
                this.setupNextPropertyCache(res, nextBmd);
            }
            finally {
                res.restoreRelationPropertyType();
                res.decrementCurrentRelationNestLevel();
            }
        }
    }

    @Override
    protected boolean isCreateDeadLink() {
        return false;
    }

    @Override
    protected int getLimitRelationNestLevel() {
        return 2;
    }

    @Override
    protected TnRelationRowCreationResource createResourceForRow(ResultSet rs, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Object> relKeyValues, Map<String, Map<String, TnPropertyMapping>> relationPropertyCache) throws SQLException {
        TnRelationRowCreationResourceExtension res = new TnRelationRowCreationResourceExtension();
        res.setResultSet(rs);
        res.setRelationPropertyType(rpt);
        res.setSelectColumnMap(selectColumnMap);
        res.setRelKeyValues(relKeyValues);
        res.setRelationPropertyCache(relationPropertyCache);
        res.setBaseSuffix("");
        res.setRelationNoSuffix(this.buildRelationNoSuffix(rpt));
        res.setLimitRelationNestLevel(this.getLimitRelationNestLevel());
        res.setCurrentRelationNestLevel(1);
        res.setCreateDeadLink(this.isCreateDeadLink());
        res.setSelectIndexMap(ResourceContext.getSelectIndexMap());
        return res;
    }

    @Override
    protected TnRelationRowCreationResource createResourceForPropertyCache(TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Map<String, TnPropertyMapping>> relationPropertyCache, String baseSuffix, String relationNoSuffix, int limitRelationNestLevel) throws SQLException {
        TnRelationRowCreationResourceExtension res = new TnRelationRowCreationResourceExtension();
        res.setRelationPropertyType(rpt);
        res.setSelectColumnMap(selectColumnMap);
        res.setRelationPropertyCache(relationPropertyCache);
        res.setBaseSuffix(baseSuffix);
        res.setRelationNoSuffix(relationNoSuffix);
        res.setLimitRelationNestLevel(limitRelationNestLevel);
        res.setCurrentRelationNestLevel(1);
        res.setSelectIndexMap(ResourceContext.getSelectIndexMap());
        return res;
    }

    protected boolean isConditionBeanSelectedRelation(TnRelationRowCreationResource res) {
        ConditionBean cb;
        return this.hasConditionBean(res) && (cb = ConditionBeanContext.getConditionBeanOnThread()).getSqlClause().hasSelectedRelation(res.getRelationNoSuffix());
    }

    protected boolean hasConditionBean(TnRelationRowCreationResource res) {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected boolean hasSelectedForeignInfo(TnRelationRowCreationResource res) {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().hasSelectedRelation(res.getRelationNoSuffix());
    }

    protected static class TnRelationRowCreationResourceExtension
    extends TnRelationRowCreationResource {
        protected Stack<TnRelationPropertyType> backupRelationPropertyType = new Stack();
        protected Stack<String> backupBaseSuffix = new Stack();
        protected Stack<String> backupRelationSuffix = new Stack();

        protected TnRelationRowCreationResourceExtension() {
        }

        @Override
        public void backupRelationPropertyType() {
            this.backupRelationPropertyType.push(this.getRelationPropertyType());
        }

        @Override
        public void restoreRelationPropertyType() {
            this.setRelationPropertyType(this.backupRelationPropertyType.pop());
        }

        @Override
        public void backupSuffixAndPrepare(String baseSuffix, String additionalRelationNoSuffix) {
            this.backupBaseSuffixExtension();
            this.backupRelationNoSuffixExtension();
            this.setBaseSuffix(baseSuffix);
            this.addRelationNoSuffix(additionalRelationNoSuffix);
        }

        @Override
        public void restoreSuffix() {
            this.restoreBaseSuffixExtension();
            this.restoreRelationNoSuffixExtension();
        }

        protected void backupBaseSuffixExtension() {
            this.backupBaseSuffix.push(this.getBaseSuffix());
        }

        protected void restoreBaseSuffixExtension() {
            this.setBaseSuffix(this.backupBaseSuffix.pop());
        }

        protected void backupRelationNoSuffixExtension() {
            this.backupRelationSuffix.push(this.getRelationNoSuffix());
        }

        protected void restoreRelationNoSuffixExtension() {
            this.setRelationNoSuffix(this.backupRelationSuffix.pop());
        }
    }
}

