/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata;

import java.util.List;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.exception.PluginValueTypeNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;

public class TnProcedureValueTypeProvider {
    public ValueType provide(Class<?> pmbType, String paramName, Class<?> paramType, String keyName, DBDef dbdef) {
        if (keyName != null) {
            return this.findValueTypeByName(pmbType, paramName, paramType, keyName);
        }
        if (List.class.isAssignableFrom(paramType)) {
            return this.findCursorValueType(dbdef);
        }
        return this.findValueTypeByType(paramType);
    }

    protected ValueType findValueTypeByName(Class<?> pmbType, String paramName, Class<?> paramType, String keyName) {
        ValueType valueType = TnValueTypes.getPluginValueType(keyName);
        if (valueType != null) {
            return valueType;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found a plug-in value type by the name.");
        br.addItem("ProcedurePmb");
        br.addElement(pmbType.getName());
        br.addItem("Parameter");
        br.addElement(paramName);
        br.addElement(paramType.getName());
        br.addItem("Key Name");
        br.addElement(keyName);
        String msg = br.buildExceptionMessage();
        throw new PluginValueTypeNotFoundException(msg);
    }

    protected ValueType findCursorValueType(DBDef dbdef) {
        if (DBDef.PostgreSQL.equals((Object)dbdef)) {
            return TnValueTypes.POSTGRESQL_RESULT_SET;
        }
        if (DBDef.Oracle.equals((Object)dbdef)) {
            return TnValueTypes.ORACLE_RESULT_SET;
        }
        return TnValueTypes.SERIALIZABLE_BYTE_ARRAY;
    }

    protected ValueType findValueTypeByType(Class<?> paramType) {
        return TnValueTypes.getValueType(paramType);
    }
}

