/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.rowcreator.impl;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyMapping;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;

public class TnRelationRowCreationResource {
    protected ResultSet _resultSet;
    protected Object _row;
    protected TnRelationPropertyType _relationPropertyType;
    protected Map<String, String> _selectColumnMap;
    protected Map<String, Object> _relKeyValues;
    protected Map<String, Map<String, TnPropertyMapping>> _relationPropertyCache;
    protected String _baseSuffix;
    protected String _relationNoSuffix;
    protected int _limitRelationNestLevel;
    protected int _currentRelationNestLevel;
    protected TnPropertyMapping _currentPropertyMapping;
    protected int _validValueCount;
    protected boolean _createDeadLink;
    protected Stack<TnRelationPropertyType> _relationPropertyTypeBackup;
    protected Stack<String> _baseSuffixBackup;
    protected Stack<String> _relationSuffixBackup;
    protected Map<String, Integer> _selectIndexMap;

    public boolean hasRowInstance() {
        return this._row != null;
    }

    public void clearRowInstance() {
        this._row = null;
    }

    public TnBeanMetaData getRelationBeanMetaData() {
        return this._relationPropertyType.getBeanMetaData();
    }

    public boolean hasNextRelationProperty() {
        return this.getRelationBeanMetaData().getRelationPropertyTypeSize() > 0;
    }

    public void backupRelationPropertyType() {
        this.getOrCreateRelationPropertyTypeBackup().push(this.getRelationPropertyType());
    }

    public void restoreRelationPropertyType() {
        this.setRelationPropertyType(this.getOrCreateRelationPropertyTypeBackup().pop());
    }

    protected Stack<TnRelationPropertyType> getOrCreateRelationPropertyTypeBackup() {
        if (this._relationPropertyTypeBackup == null) {
            this._relationPropertyTypeBackup = new Stack();
        }
        return this._relationPropertyTypeBackup;
    }

    public boolean containsSelectColumn(String columnName) {
        return this._selectColumnMap.containsKey(columnName);
    }

    public boolean existsRelKeyValues() {
        return this._relKeyValues != null;
    }

    public boolean containsRelKeyValue(String key) {
        return this._relKeyValues.containsKey(key);
    }

    public boolean containsRelKeyValueIfExists(String key) {
        return this.existsRelKeyValues() && this._relKeyValues.containsKey(key);
    }

    public Object extractRelKeyValue(String key) {
        return this._relKeyValues.get(key);
    }

    public void initializePropertyCacheElement() {
        this._relationPropertyCache.put(this._relationNoSuffix, new HashMap());
    }

    public boolean hasPropertyCacheElement() {
        Map<String, TnPropertyMapping> propertyCacheElement = this.extractPropertyCacheElement();
        return propertyCacheElement != null && !propertyCacheElement.isEmpty();
    }

    public Map<String, TnPropertyMapping> extractPropertyCacheElement() {
        return this._relationPropertyCache.get(this._relationNoSuffix);
    }

    public void savePropertyCacheElement() {
        String columnName;
        Map<String, TnPropertyMapping> propertyCacheElement;
        if (!this.hasPropertyCacheElement()) {
            this.initializePropertyCacheElement();
        }
        if ((propertyCacheElement = this.extractPropertyCacheElement()).containsKey(columnName = this.buildRelationColumnName())) {
            return;
        }
        propertyCacheElement.put(columnName, this._currentPropertyMapping);
    }

    public String buildRelationColumnName() {
        return this._currentPropertyMapping.getColumnDbName() + this._relationNoSuffix;
    }

    public void addRelationNoSuffix(String additionalRelationNoSuffix) {
        this._relationNoSuffix = this._relationNoSuffix + additionalRelationNoSuffix;
    }

    public void backupSuffixAndPrepare(String baseSuffix, String additionalRelationNoSuffix) {
        this.backupBaseSuffix();
        this.backupRelationNoSuffix();
        this._baseSuffix = baseSuffix;
        this.addRelationNoSuffix(additionalRelationNoSuffix);
    }

    public void restoreSuffix() {
        this.restoreBaseSuffix();
        this.restoreRelationNoSuffix();
    }

    protected void backupBaseSuffix() {
        this.getOrCreateBaseSuffixBackup().push(this.getBaseSuffix());
    }

    protected void restoreBaseSuffix() {
        this.setBaseSuffix(this.getOrCreateBaseSuffixBackup().pop());
    }

    protected Stack<String> getOrCreateBaseSuffixBackup() {
        if (this._baseSuffixBackup == null) {
            this._baseSuffixBackup = new Stack();
        }
        return this._baseSuffixBackup;
    }

    protected void backupRelationNoSuffix() {
        this.getOrCreateRelationNoSuffixBackup().push(this.getRelationNoSuffix());
    }

    protected void restoreRelationNoSuffix() {
        this.setRelationNoSuffix(this.getOrCreateRelationNoSuffixBackup().pop());
    }

    protected Stack<String> getOrCreateRelationNoSuffixBackup() {
        if (this._relationSuffixBackup == null) {
            this._relationSuffixBackup = new Stack();
        }
        return this._relationSuffixBackup;
    }

    public boolean hasNextRelationLevel() {
        return this._currentRelationNestLevel < this._limitRelationNestLevel;
    }

    public void incrementCurrentRelationNestLevel() {
        ++this._currentRelationNestLevel;
    }

    public void decrementCurrentRelationNestLevel() {
        --this._currentRelationNestLevel;
    }

    public void incrementValidValueCount() {
        ++this._validValueCount;
    }

    public void clearValidValueCount() {
        this._validValueCount = 0;
    }

    public boolean hasValidValueCount() {
        return this._validValueCount > 0;
    }

    public ResultSet getResultSet() {
        return this._resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this._resultSet = resultSet;
    }

    public Map<String, String> getSelectColumnMap() {
        return this._selectColumnMap;
    }

    public void setSelectColumnMap(Map<String, String> selectColumnMap) {
        this._selectColumnMap = selectColumnMap;
    }

    public Map<String, Object> getRelKeyValues() {
        return this._relKeyValues;
    }

    public void setRelKeyValues(Map<String, Object> relKeyValues) {
        this._relKeyValues = relKeyValues;
    }

    public Object getRow() {
        return this._row;
    }

    public void setRow(Object row) {
        this._row = row;
    }

    public TnRelationPropertyType getRelationPropertyType() {
        return this._relationPropertyType;
    }

    public void setRelationPropertyType(TnRelationPropertyType rpt) {
        this._relationPropertyType = rpt;
    }

    public Map<String, Map<String, TnPropertyMapping>> getRelationPropertyCache() {
        return this._relationPropertyCache;
    }

    public void setRelationPropertyCache(Map<String, Map<String, TnPropertyMapping>> relationPropertyCache) {
        this._relationPropertyCache = relationPropertyCache;
    }

    public String getBaseSuffix() {
        return this._baseSuffix;
    }

    public void setBaseSuffix(String baseSuffix) {
        this._baseSuffix = baseSuffix;
    }

    public String getRelationNoSuffix() {
        return this._relationNoSuffix;
    }

    public void setRelationNoSuffix(String relationNoSuffix) {
        this._relationNoSuffix = relationNoSuffix;
    }

    public int getLimitRelationNestLevel() {
        return this._limitRelationNestLevel;
    }

    public void setLimitRelationNestLevel(int limitRelationNestLevel) {
        this._limitRelationNestLevel = limitRelationNestLevel;
    }

    public int getCurrentRelationNestLevel() {
        return this._currentRelationNestLevel;
    }

    public void setCurrentRelationNestLevel(int currentRelationNestLevel) {
        this._currentRelationNestLevel = currentRelationNestLevel;
    }

    public TnPropertyMapping getCurrentPropertyMapping() {
        return this._currentPropertyMapping;
    }

    public void setCurrentPropertyType(TnPropertyMapping propertyType) {
        this._currentPropertyMapping = propertyType;
    }

    public boolean isCreateDeadLink() {
        return this._createDeadLink;
    }

    public void setCreateDeadLink(boolean createDeadLink) {
        this._createDeadLink = createDeadLink;
    }

    public Map<String, Integer> getSelectIndexMap() {
        return this._selectIndexMap;
    }

    public void setSelectIndexMap(Map<String, Integer> selectIndexMap) {
        this._selectIndexMap = selectIndexMap;
    }
}

