/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest;

import java.util.ArrayList;
import java.util.List;
import jp.sf.fess.suggest.converter.SuggestConverter;

public class Suggester {
    protected final List<SuggestConverter> preQueryConverterList = new ArrayList<SuggestConverter>();
    protected final List<SuggestConverter> queryConverterList = new ArrayList<SuggestConverter>();
    protected final List<SuggestConverter> resultConverterList = new ArrayList<SuggestConverter>();
    public String wordSeprator = "_SP_";

    public void addQueryConverter(SuggestConverter converter) {
        this.queryConverterList.add(converter);
    }

    public void addPreQueryConverter(SuggestConverter converter) {
        this.preQueryConverterList.add(converter);
    }

    public void addResultConverter(SuggestConverter converter) {
        this.resultConverterList.add(converter);
    }

    public String convertQuery(String query) {
        String target = query;
        for (SuggestConverter conveter : this.preQueryConverterList) {
            target = conveter.convert(target);
        }
        ArrayList<String> queryList = new ArrayList<String>();
        for (SuggestConverter converter : this.queryConverterList) {
            String convertedQuery = converter.convert(target);
            if (convertedQuery == null || (convertedQuery = convertedQuery.trim()).length() <= 0) continue;
            queryList.add(convertedQuery);
        }
        StringBuilder resultStrBuff = new StringBuilder(255);
        for (int i = 0; i < queryList.size(); ++i) {
            if (i > 0) {
                resultStrBuff.append(' ');
            }
            resultStrBuff.append((String)queryList.get(i));
        }
        return resultStrBuff.toString();
    }

    public String convertResultString(String suggestTerm) {
        String target;
        String[] strArray = suggestTerm.split(this.wordSeprator);
        if (strArray.length == 1) {
            target = strArray[0];
        } else if (strArray.length == 2) {
            target = strArray[1];
        } else {
            return "";
        }
        for (SuggestConverter conveter : this.preQueryConverterList) {
            target = conveter.convert(target);
        }
        return target;
    }
}

