/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean.chelper;

import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.ConditionQuery;
import org.seasar.robot.dbflute.cbean.chelper.HpCBPurpose;
import org.seasar.robot.dbflute.cbean.chelper.HpSpQyCall;
import org.seasar.robot.dbflute.cbean.chelper.HpSpecifiedColumn;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.DBMetaProvider;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.exception.thrower.ConditionBeanExceptionThrower;
import org.seasar.robot.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HpAbstractSpecification<CQ extends ConditionQuery> {
    protected final ConditionBean _baseCB;
    protected final HpSpQyCall<CQ> _qyCall;
    protected HpSpQyCall<CQ> _syncQyCall;
    protected final HpCBPurpose _purpose;
    protected final DBMetaProvider _dbmetaProvider;
    protected CQ _query;
    protected boolean _alreadySpecifiedRequiredColumn;
    protected Map<String, HpSpecifiedColumn> _specifiedColumnMap;

    protected HpAbstractSpecification(ConditionBean baseCB, HpSpQyCall<CQ> qyCall, HpCBPurpose purpose, DBMetaProvider dbmetaProvider) {
        this._baseCB = baseCB;
        this._qyCall = qyCall;
        this._purpose = purpose;
        this._dbmetaProvider = dbmetaProvider;
    }

    protected HpSpecifiedColumn doColumn(String columnName) {
        if (this.isSpecifiedColumn(columnName)) {
            return this.getSpecifiedColumn(columnName);
        }
        this.assertColumn(columnName);
        if (this._query == null) {
            this._query = this.qyCall().qy();
        }
        if (this.isRequiredColumnSpecificationEnabled()) {
            this._alreadySpecifiedRequiredColumn = true;
            this.doSpecifyRequiredColumn();
        }
        String relationPath = this._query.xgetRelationPath() != null ? this._query.xgetRelationPath() : "";
        SqlClause sqlClause = this._baseCB.getSqlClause();
        String tableAliasName = this._query.isBaseQuery() ? sqlClause.getBasePointAliasName() : sqlClause.resolveJoinAliasName(relationPath, this._query.xgetNestLevel());
        HpSpecifiedColumn specifiedColumn = this.createSpecifiedColumn(columnName, tableAliasName);
        sqlClause.specifySelectColumn(specifiedColumn);
        this.saveSpecifiedColumn(columnName, specifiedColumn);
        return specifiedColumn;
    }

    protected HpSpQyCall<CQ> qyCall() {
        return this._syncQyCall != null ? this._syncQyCall : this._qyCall;
    }

    protected boolean isRequiredColumnSpecificationEnabled() {
        if (this._alreadySpecifiedRequiredColumn) {
            return false;
        }
        return this.isNormalUse();
    }

    protected abstract void doSpecifyRequiredColumn();

    protected abstract String getTableDbName();

    protected HpSpecifiedColumn createSpecifiedColumn(String columnName, String tableAliasName) {
        DBMeta dbmeta = this._dbmetaProvider.provideDBMetaChecked(this._query.getTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnName);
        return new HpSpecifiedColumn(tableAliasName, columnInfo);
    }

    protected HpSpecifiedColumn getSpecifiedColumn(String columnName) {
        return this._specifiedColumnMap != null ? this._specifiedColumnMap.get(columnName) : null;
    }

    protected boolean isSpecifiedColumn(String columnName) {
        return this._specifiedColumnMap != null && this._specifiedColumnMap.containsKey(columnName);
    }

    protected void saveSpecifiedColumn(String columnName, HpSpecifiedColumn specifiedColumn) {
        if (this._specifiedColumnMap == null) {
            this._specifiedColumnMap = new LinkedHashMap<String, HpSpecifiedColumn>();
        }
        this._specifiedColumnMap.put(columnName, specifiedColumn);
    }

    protected void assertColumn(String columnName) {
        if (this._purpose.isNoSpecifyColumnTwoOrMore() && this._specifiedColumnMap != null && this._specifiedColumnMap.size() > 0) {
            this.throwSpecifyColumnTwoOrMoreColumnException(columnName);
        }
        if (this._purpose.isNoSpecifyColumnWithDerivedReferrer() && this.hasDerivedReferrer()) {
            this.throwSpecifyColumnWithDerivedReferrerException(columnName, null);
        }
        if (this.isNormalUse() && this._query == null && !this.qyCall().has()) {
            this.throwSpecifyColumnNotSetupSelectColumnException(columnName);
        }
    }

    protected void assertRelation(String relationName) {
        if (this._purpose.isNoSpecifyRelation()) {
            this.throwSpecifyRelationIllegalPurposeException(relationName);
        }
    }

    protected void assertDerived(String referrerName) {
        if (this._purpose.isNoSpecifyDerivedReferrer()) {
            this.throwSpecifyDerivedReferrerIllegalPurposeException(referrerName);
        }
        if (this._purpose.isNoSpecifyDerivedReferrerTwoOrMore() && this.hasDerivedReferrer()) {
            this.throwSpecifyDerivedReferrerTwoOrMoreException(referrerName);
        }
        if (this._purpose.isNoSpecifyColumnWithDerivedReferrer() && this._specifiedColumnMap != null && this._specifiedColumnMap.size() > 0) {
            this.throwSpecifyColumnWithDerivedReferrerException(null, referrerName);
        }
    }

    protected boolean isNormalUse() {
        return HpCBPurpose.NORMAL_USE.equals((Object)this._purpose);
    }

    public boolean isAlreadySpecifiedRequiredColumn() {
        return this._alreadySpecifiedRequiredColumn;
    }

    protected boolean hasDerivedReferrer() {
        return !this._baseCB.getSqlClause().getSpecifiedDerivingAliasList().isEmpty();
    }

    public HpSpQyCall<CQ> xsyncQyCall() {
        return this._syncQyCall;
    }

    public void xsetSyncQyCall(HpSpQyCall<CQ> qyCall) {
        this._syncQyCall = qyCall;
    }

    public boolean xhasSyncQyCall() {
        return this._syncQyCall != null;
    }

    protected void throwSpecifyColumnTwoOrMoreColumnException(String columnName) {
        this.createCBExThrower().throwSpecifyColumnTwoOrMoreColumnException(this._purpose, this._baseCB, columnName);
    }

    protected void throwSpecifyColumnNotSetupSelectColumnException(String columnName) {
        this.createCBExThrower().throwSpecifyColumnNotSetupSelectColumnException(this._baseCB, columnName);
    }

    protected void throwSpecifyColumnWithDerivedReferrerException(String columnName, String referrerName) {
        this.createCBExThrower().throwSpecifyColumnWithDerivedReferrerException(this._purpose, this._baseCB, columnName, referrerName);
    }

    protected void throwSpecifyRelationIllegalPurposeException(String relationName) {
        this.createCBExThrower().throwSpecifyRelationIllegalPurposeException(this._purpose, this._baseCB, relationName);
    }

    protected void throwSpecifyDerivedReferrerIllegalPurposeException(String referrerName) {
        this.createCBExThrower().throwSpecifyDerivedReferrerIllegalPurposeException(this._purpose, this._baseCB, referrerName);
    }

    protected void throwSpecifyDerivedReferrerTwoOrMoreException(String referrerName) {
        this.createCBExThrower().throwSpecifyDerivedReferrerTwoOrMoreException(this._purpose, this._baseCB, referrerName);
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

