/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.mapstring.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.helper.mapstring.MapListString;
import org.seasar.robot.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapListStringImpl
implements MapListString {
    protected String _mapMark = "map:";
    protected String _listMark = "list:";
    protected String _startBrace = "{";
    protected String _endBrace = "}";
    protected String _delimiter = ";";
    protected String _equal = "=";
    protected String _topString;
    protected String _remainderString;

    @Override
    public String buildMapString(Map<String, ? extends Object> map) {
        StringBuilder sb = new StringBuilder();
        Map<String, Object> casted = map;
        this.doBuildMapString(sb, casted, "", "    ");
        return sb.toString();
    }

    protected void doBuildMapString(StringBuilder sb, Map<String, Object> map, String preIndent, String curIndent) {
        sb.append(this._mapMark).append(this._startBrace);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sb.append(this.ln()).append(curIndent).append(this._delimiter);
            sb.append(" ").append(key).append(" ").append(this._equal).append(" ");
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                this.doBuildMapString(sb, valueMap, curIndent, this.calculateNextIndent(preIndent, curIndent));
                continue;
            }
            if (value instanceof List) {
                List valueList = (List)value;
                this.doBuildListString(sb, valueList, curIndent, this.calculateNextIndent(preIndent, curIndent));
                continue;
            }
            sb.append(value);
        }
        sb.append(this.ln()).append(preIndent).append(this._endBrace);
    }

    @Override
    public String buildListString(List<? extends Object> list) {
        StringBuilder sb = new StringBuilder();
        List<? extends Object> casted = list;
        this.doBuildListString(sb, casted, "", "    ");
        return sb.toString();
    }

    protected void doBuildListString(StringBuilder sb, List<? extends Object> list, String preIndent, String curIndent) {
        sb.append(this._listMark).append(this._startBrace);
        for (Object object : list) {
            sb.append(this.ln()).append(curIndent).append(this._delimiter);
            sb.append(" ");
            if (object instanceof Map) {
                Map valueMap = (Map)object;
                this.doBuildMapString(sb, valueMap, curIndent, this.calculateNextIndent(preIndent, curIndent));
                continue;
            }
            if (object instanceof List) {
                List valueList = (List)object;
                this.doBuildListString(sb, valueList, curIndent, this.calculateNextIndent(preIndent, curIndent));
                continue;
            }
            sb.append(object);
        }
        sb.append(this.ln()).append(preIndent).append(this._endBrace);
    }

    protected String calculateNextIndent(String preIndent, String curIndent) {
        StringBuilder sb = new StringBuilder();
        int indentLength = curIndent.length() - preIndent.length();
        for (int i = 0; i < indentLength; ++i) {
            sb.append(" ");
        }
        return curIndent + sb.toString();
    }

    @Override
    public Map<String, Object> generateMap(String mapString) {
        this.assertMapString(mapString);
        this._topString = mapString;
        this._remainderString = mapString;
        this.removeBothSideSpaceAndTabAndNewLine();
        this.removePrefixMapMarkAndStartBrace();
        Map<String, Object> generatedMap = this.newStringObjectMap();
        this.parseRemainderMapString(generatedMap);
        if (!"".equals(this._remainderString)) {
            String msg = "Final remainderString must be empty string:";
            msg = msg + this.lnd() + " # remainderString --> " + this._remainderString;
            msg = msg + this.lnd() + " # mapString --> " + mapString;
            msg = msg + this.lnd() + " # generatedMap --> " + generatedMap;
            throw new IllegalStateException(msg);
        }
        return generatedMap;
    }

    @Override
    public List<Object> generateList(String listString) {
        this.assertListString(listString);
        this._topString = listString;
        this._remainderString = listString;
        this.removeBothSideSpaceAndTabAndNewLine();
        this.removePrefixListMarkAndStartBrace();
        List<Object> generatedList = this.newObjectList();
        this.parseRemainderListString(generatedList);
        if (!"".equals(this._remainderString)) {
            String msg = "Final remainderString must be empty string:";
            msg = msg + this.lnd() + " # remainderString --> " + this._remainderString;
            msg = msg + this.lnd() + " # listString --> " + listString;
            msg = msg + this.lnd() + " # generatedList --> " + generatedList;
            throw new IllegalStateException(msg);
        }
        return generatedList;
    }

    protected void parseRemainderMapString(Map<String, Object> currentMap) {
        String mapValue;
        int endBraceIndex;
        String mapKey;
        while (true) {
            if (this.initializeAtLoopBeginning()) {
                return;
            }
            int equalIndex = this._remainderString.indexOf(this._equal);
            this.assertEqualIndex(this._remainderString, equalIndex, this._topString, currentMap);
            mapKey = this._remainderString.substring(0, equalIndex).trim();
            this.removePrefixTargetIndexPlus(equalIndex, this._equal.length());
            this.removeBothSideSpaceAndTabAndNewLine();
            if (this.isStartsWithMapPrefix(this._remainderString)) {
                this.removePrefixMapMarkAndStartBrace();
                this.parseRemainderMapString(this.setupNestMap(currentMap, mapKey));
                if (!this.closingAfterParseNestMapList()) continue;
                return;
            }
            if (this.isStartsWithListPrefix(this._remainderString)) {
                this.removePrefixListMarkAndStartBrace();
                this.parseRemainderListString(this.setupNestList(currentMap, mapKey));
                if (!this.closingAfterParseNestMapList()) continue;
                return;
            }
            int delimiterIndex = this._remainderString.indexOf(this._delimiter);
            endBraceIndex = this._remainderString.indexOf(this._endBrace);
            this.assertEndBracekIndex(this._remainderString, endBraceIndex, this._topString, currentMap);
            if (delimiterIndex < 0 || delimiterIndex >= endBraceIndex) break;
            mapValue = this._remainderString.substring(0, delimiterIndex);
            currentMap.put(mapKey, this.filterMapListValue(mapValue));
            this.removePrefixTargetIndexPlus(delimiterIndex, this._delimiter.length());
        }
        mapValue = this._remainderString.substring(0, endBraceIndex);
        currentMap.put(mapKey, this.filterMapListValue(mapValue));
        this.closingByEndBraceIndex(endBraceIndex);
    }

    protected void parseRemainderListString(List<Object> currentList) {
        String listValue;
        int endBraceIndex;
        while (true) {
            if (this.initializeAtLoopBeginning()) {
                return;
            }
            if (this.isStartsWithMapPrefix(this._remainderString)) {
                this.removePrefixMapMarkAndStartBrace();
                this.parseRemainderMapString(this.setupNestMap(currentList));
                if (!this.closingAfterParseNestMapList()) continue;
                return;
            }
            if (this.isStartsWithListPrefix(this._remainderString)) {
                this.removePrefixListMarkAndStartBrace();
                this.parseRemainderListString(this.setupNestList(currentList));
                if (!this.closingAfterParseNestMapList()) continue;
                return;
            }
            int delimiterIndex = this._remainderString.indexOf(this._delimiter);
            endBraceIndex = this._remainderString.indexOf(this._endBrace);
            this.assertEndBraceIndex(this._remainderString, endBraceIndex, this._topString, currentList);
            if (delimiterIndex < 0 || delimiterIndex >= endBraceIndex) break;
            listValue = this._remainderString.substring(0, delimiterIndex);
            currentList.add(this.filterMapListValue(listValue));
            this.removePrefixTargetIndexPlus(delimiterIndex, this._delimiter.length());
        }
        listValue = this._remainderString.substring(0, endBraceIndex);
        currentList.add(this.filterMapListValue(listValue));
        this.closingByEndBraceIndex(endBraceIndex);
    }

    protected boolean initializeAtLoopBeginning() {
        this.removePrefixAllDelimiter();
        if (this._remainderString.equals("")) {
            return true;
        }
        if (this.isStartsWithEndBrace(this._remainderString)) {
            this.removePrefixEndBrace();
            return true;
        }
        return false;
    }

    protected boolean closingAfterParseNestMapList() {
        if (this.isStartsWithEndBrace(this._remainderString)) {
            this.removePrefixEndBrace();
            return true;
        }
        return false;
    }

    protected void closingByEndBraceIndex(int endBraceIndex) {
        this._remainderString = this._remainderString.substring(endBraceIndex);
        this.removePrefixEndBrace();
    }

    protected void removePrefixMapMarkAndStartBrace() {
        this.removePrefix(this._mapMark + this._startBrace);
    }

    protected void removePrefixListMarkAndStartBrace() {
        this.removePrefix(this._listMark + this._startBrace);
    }

    protected void removePrefixDelimiter() {
        this.removePrefix(this._delimiter);
    }

    protected void removePrefixEndBrace() {
        this.removePrefix(this._endBrace);
    }

    protected void removePrefix(String prefixString) {
        if (this._remainderString == null) {
            String msg = "Argument[remainderString] must not be null: " + this._remainderString;
            throw new IllegalArgumentException(msg);
        }
        if (prefixString == null) {
            String msg = "Argument[prefixString] must not be null!";
            throw new IllegalArgumentException(msg);
        }
        this.removeBothSideSpaceAndTabAndNewLine();
        if (this._remainderString.length() < prefixString.length()) {
            String msg = "Argument[remainderString] length must be larger than Argument[prefixString] length:";
            msg = msg + this.lnd() + " # remainderString --> " + this._remainderString;
            msg = msg + this.lnd() + " # prefixString=" + prefixString;
            throw new IllegalArgumentException(msg);
        }
        if (!this._remainderString.startsWith(prefixString)) {
            String msg = "Argument[remainderString] must start with Argument[prefixString:]";
            msg = msg + this.lnd() + " # remainderString --> " + this._remainderString;
            msg = msg + this.lnd() + " # prefixString --> " + prefixString;
            throw new IllegalArgumentException(msg);
        }
        this._remainderString = this._remainderString.substring(prefixString.length());
        this.removeBothSideSpaceAndTabAndNewLine();
    }

    protected void removePrefixAllDelimiter() {
        this.removeBothSideSpaceAndTabAndNewLine();
        while (this.isStartsWithDelimiter(this._remainderString)) {
            if (!this.isStartsWithDelimiter(this._remainderString)) continue;
            this.removePrefixDelimiter();
            this.removeBothSideSpaceAndTabAndNewLine();
        }
    }

    protected void removeBothSideSpaceAndTabAndNewLine() {
        this._remainderString = this._remainderString.trim();
    }

    protected void removePrefixTargetIndexPlus(int index, int plusCount) {
        this._remainderString = this._remainderString.substring(index + plusCount);
    }

    protected String filterMapListValue(String value) {
        if (value == null) {
            return null;
        }
        return "".equals(value = value.trim()) || "null".equals(value) ? null : value;
    }

    protected boolean isStartsWithMapPrefix(String targetString) {
        if (targetString == null) {
            String msg = "Argument[targetString] must not be null!";
            throw new IllegalArgumentException(msg);
        }
        return (targetString = targetString.trim()).startsWith(this._mapMark + this._startBrace);
    }

    protected boolean isStartsWithListPrefix(String targetString) {
        if (targetString == null) {
            String msg = "Argument[targetString] must not be null!";
            throw new IllegalArgumentException(msg);
        }
        return (targetString = targetString.trim()).startsWith(this._listMark + this._startBrace);
    }

    protected boolean isStartsWithDelimiter(String targetString) {
        if (targetString == null) {
            String msg = "Argument[targetString] must not be null!";
            throw new IllegalArgumentException(msg);
        }
        return (targetString = targetString.trim()).startsWith(this._delimiter);
    }

    protected boolean isStartsWithEndBrace(String targetString) {
        if (targetString == null) {
            String msg = "Argument[targetString] must not be null!";
            throw new IllegalArgumentException(msg);
        }
        return (targetString = targetString.trim()).startsWith(this._endBrace);
    }

    protected boolean isEndsWithEndBrace(String targetString) {
        if (targetString == null) {
            String msg = "Argument[targetString] must not be null!";
            throw new IllegalArgumentException(msg);
        }
        return (targetString = targetString.trim()).endsWith(this._endBrace);
    }

    protected Map<String, Object> setupNestMap(Map<String, Object> currentMap, String mapKey) {
        Map<String, Object> nestMap = this.newStringObjectMap();
        currentMap.put(mapKey, nestMap);
        return nestMap;
    }

    protected Map<String, Object> setupNestMap(List<Object> currentList) {
        Map<String, Object> nestMap = this.newStringObjectMap();
        currentList.add(nestMap);
        return nestMap;
    }

    protected List<Object> setupNestList(Map<String, Object> currentMap, String mapKey) {
        List<Object> nestList = this.newObjectList();
        currentMap.put(mapKey, nestList);
        return nestList;
    }

    protected List<Object> setupNestList(List<Object> currentList) {
        List<Object> nestList = this.newObjectList();
        currentList.add(nestList);
        return nestList;
    }

    protected Map<String, Object> newStringObjectMap() {
        return new LinkedHashMap<String, Object>();
    }

    protected List<Object> newObjectList() {
        return new ArrayList<Object>();
    }

    protected int getDelimiterCount(String targetString, String delimiter) {
        int result = 0;
        int i = 0;
        while (targetString.indexOf(delimiter, i) != -1) {
            ++result;
            i = targetString.indexOf(delimiter, i) + 1;
        }
        if (result == 0) {
            result = -1;
        }
        return result;
    }

    protected void assertMapString(String mapString) {
        int endBraceCount;
        if (mapString == null) {
            String msg = "Argument[mapString] must not be null: ";
            throw new IllegalArgumentException(msg + "mapString=null");
        }
        if (!this.isStartsWithMapPrefix(mapString = mapString.trim())) {
            String msg = "Argument[mapString] must start with '" + this._mapMark + this._startBrace + "': ";
            throw new IllegalArgumentException(msg + "mapString=" + mapString);
        }
        if (!this.isEndsWithEndBrace(mapString)) {
            String msg = "Argument[mapString] must end with '" + this._endBrace + "': ";
            throw new IllegalArgumentException(msg + "mapString=" + mapString);
        }
        int startBraceCount = this.getDelimiterCount(mapString, this._startBrace);
        if (startBraceCount != (endBraceCount = this.getDelimiterCount(mapString, this._endBrace))) {
            String msg = "It is necessary to have braces of the same number on start and end:";
            msg = msg + this.lnd() + " # mapString --> " + mapString;
            msg = msg + this.lnd() + " # startBraceCount --> " + startBraceCount;
            msg = msg + this.lnd() + " # endBraceCount --> " + endBraceCount;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListString(String listString) {
        int endBraceCount;
        if (listString == null) {
            String msg = "Argument[listString] must not be null: ";
            throw new IllegalArgumentException(msg + "listString=null");
        }
        if (!this.isStartsWithListPrefix(listString = listString.trim())) {
            String msg = "Argument[listString] must start with '" + this._mapMark + "': ";
            throw new IllegalArgumentException(msg + "listString=" + listString);
        }
        if (!this.isEndsWithEndBrace(listString)) {
            String msg = "Argument[listString] must end with '" + this._endBrace + "': ";
            throw new IllegalArgumentException(msg + "listString=" + listString);
        }
        int startBraceCount = this.getDelimiterCount(listString, this._startBrace);
        if (startBraceCount != (endBraceCount = this.getDelimiterCount(listString, this._endBrace))) {
            String msg = "It is necessary to have braces of the same number on start and end:";
            msg = msg + this.lnd() + " # listString --> " + listString;
            msg = msg + this.lnd() + " # startBraceCount --> " + startBraceCount;
            msg = msg + this.lnd() + " # endBraceCount --> " + endBraceCount;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertEqualIndex(String remainderMapString, int equalIndex, String mapString4Log, Map<String, Object> currentMap4Log) {
        if (remainderMapString == null) {
            String msg = "Argument[remainderMapString] must not be null:";
            msg = msg + this.lnd() + " # remainderMapString --> null";
            msg = msg + this.lnd() + " # equalIndex --> " + equalIndex;
            msg = msg + this.lnd() + " # mapString4Log --> " + mapString4Log;
            msg = msg + this.lnd() + " # currentMap4Log --> " + currentMap4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
        if (equalIndex < 0) {
            String msg = "Argument[equalIndex] must be plus or zero:";
            msg = msg + this.lnd() + " # remainderMapString --> " + remainderMapString;
            msg = msg + this.lnd() + " # equalIndex --> " + equalIndex;
            msg = msg + this.lnd() + " # mapString4Log --> " + mapString4Log;
            msg = msg + this.lnd() + " # currentMap4Log --> " + currentMap4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
        if (remainderMapString.length() < equalIndex) {
            String msg = "Argument[remainderMapString] length must be larger than equalIndex value:";
            msg = msg + this.lnd() + " # remainderMapString --> " + remainderMapString;
            msg = msg + this.lnd() + " # equalIndex --> " + equalIndex;
            msg = msg + this.lnd() + " # mapString4Log --> " + mapString4Log;
            msg = msg + this.lnd() + " # currentMap4Log --> " + currentMap4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
        String expectedAsEndMark = remainderMapString.substring(equalIndex, equalIndex + this._equal.length());
        if (!expectedAsEndMark.equals(this._equal)) {
            String msg = "Argument[remainderMapString] must have '" + this._equal + "' at Argument[equalIndex]:";
            msg = msg + this.lnd() + " # remainderMapString --> " + remainderMapString;
            msg = msg + this.lnd() + " # equalIndex --> " + equalIndex;
            msg = msg + this.lnd() + " # expectedAsEndMark --> " + expectedAsEndMark;
            msg = msg + this.lnd() + " # mapString --> " + mapString4Log;
            msg = msg + this.lnd() + " # currentMap --> " + currentMap4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertEndBracekIndex(String remainderMapString, int endBraceIndex, String mapString4Log, Map<String, Object> currentMap4Log) {
        if (remainderMapString == null) {
            String msg = "Argument[remainderMapString] must not be null:";
            msg = msg + this.lnd() + " # remainderMapString --> null";
            msg = msg + this.lnd() + " # endBraceIndex --> " + endBraceIndex;
            msg = msg + this.lnd() + " # mapString --> " + mapString4Log;
            msg = msg + this.lnd() + " # currentMap --> " + currentMap4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
        if (endBraceIndex < 0) {
            String msg = "Argument[endMarkIndex] must be plus or zero:";
            msg = msg + this.lnd() + " # remainderMapString --> " + remainderMapString;
            msg = msg + this.lnd() + " # endBraceIndex --> " + endBraceIndex;
            msg = msg + this.lnd() + " # mapString --> =" + mapString4Log;
            msg = msg + this.lnd() + " # currentMap --> " + currentMap4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
        if (remainderMapString.length() < endBraceIndex) {
            String msg = "Argument[remainderMapString] length must be larger than endMarkIndex value:";
            msg = msg + this.lnd() + " # remainderMapString --> " + remainderMapString;
            msg = msg + this.lnd() + " # endBraceIndex --> " + endBraceIndex;
            msg = msg + this.lnd() + " # mapString --> " + mapString4Log;
            msg = msg + this.lnd() + " # currentMap --> " + currentMap4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
        String expectedAsEndMark = remainderMapString.substring(endBraceIndex, endBraceIndex + this._endBrace.length());
        if (!expectedAsEndMark.equals(this._endBrace)) {
            String msg = "Argument[remainderMapString] must have '" + this._endBrace + "' at Argument[endBraceIndex]:";
            msg = msg + this.lnd() + " # remainderMapString --> " + remainderMapString;
            msg = msg + this.lnd() + " # endBraceIndex --> " + endBraceIndex;
            msg = msg + this.lnd() + " # expectedAsEndMark --> " + expectedAsEndMark;
            msg = msg + this.lnd() + " # mapString --> " + mapString4Log;
            msg = msg + this.lnd() + " # currentMap --> " + currentMap4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertEndBraceIndex(String remainderListString, int endBraceIndex, String listString4Log, List<?> currentList4Log) {
        if (remainderListString == null) {
            String msg = "Argument[remainderListString] must not be null:";
            msg = msg + this.lnd() + " # remainderListString --> null";
            msg = msg + this.lnd() + " # endBraceIndex --> " + endBraceIndex;
            msg = msg + this.lnd() + " # listString --> " + listString4Log;
            msg = msg + this.lnd() + " # currentList --> " + currentList4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
        if (endBraceIndex < 0) {
            String msg = "Argument[endMarkIndex] must be plus or zero:";
            msg = msg + this.lnd() + " # remainderListString --> " + remainderListString;
            msg = msg + this.lnd() + " # endBraceIndex --> " + endBraceIndex;
            msg = msg + this.lnd() + " # listString --> " + listString4Log;
            msg = msg + this.lnd() + " # currentList --> " + currentList4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
        if (remainderListString.length() < endBraceIndex) {
            String msg = "Argument[remainderListString] length must be larger than endMarkIndex value:";
            msg = msg + this.lnd() + " # remainderListString --> " + remainderListString;
            msg = msg + this.lnd() + " # endBraceIndex --> " + endBraceIndex;
            msg = msg + this.lnd() + " # listString --> " + listString4Log;
            msg = msg + this.lnd() + " # currentList --> " + currentList4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
        String expectedAsEndBrace = remainderListString.substring(endBraceIndex, endBraceIndex + this._endBrace.length());
        if (!expectedAsEndBrace.equals(this._endBrace)) {
            String msg = "Argument[remainderListString] must have '" + this._endBrace + "' at Argument[endBraceIndex]:";
            msg = msg + this.lnd() + " # remainderListString --> " + remainderListString;
            msg = msg + this.lnd() + " # endBraceIndex --> " + endBraceIndex;
            msg = msg + this.lnd() + " # expectedAsEndBrace --> " + expectedAsEndBrace;
            msg = msg + this.lnd() + " # listString --> " + listString4Log;
            msg = msg + this.lnd() + " # currentList --> " + currentList4Log;
            msg = msg + this.lnd() + " # _startBrace --> " + this._startBrace;
            msg = msg + this.lnd() + " # _endBrace --> " + this._endBrace;
            msg = msg + this.lnd() + " # _delimiter --> " + this._delimiter;
            msg = msg + this.lnd() + " # _equal --> " + this._equal;
            throw new IllegalArgumentException(msg);
        }
    }

    protected String lnd() {
        return this.ln() + "    ";
    }

    protected final String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public void setMapMark(String mapMark) {
        this._mapMark = mapMark;
    }

    public void setListMark(String listMark) {
        this._listMark = listMark;
    }

    public synchronized void setStartBrace(String startBrace) {
        this._startBrace = startBrace;
    }

    public synchronized void setEndBrace(String endBrace) {
        this._endBrace = endBrace;
    }

    public synchronized void setDelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    public void setEqual(String equal) {
        this._equal = equal;
    }
}

