/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.rowcreator.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.seasar.robot.dbflute.helper.StringKeyMap;
import org.seasar.robot.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyMapping;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.robot.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.robot.dbflute.s2dao.rowcreator.TnRelationRowCreator;
import org.seasar.robot.dbflute.s2dao.rowcreator.impl.TnRelationRowCreationResource;
import org.seasar.robot.dbflute.util.DfReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnRelationRowCreatorImpl
implements TnRelationRowCreator {
    @Override
    public Object createRelationRow(ResultSet rs, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Object> relKeyValues, Map<String, Map<String, TnPropertyMapping>> relationPropertyCache) throws SQLException {
        TnRelationRowCreationResource res = this.createResourceForRow(rs, rpt, selectColumnMap, relKeyValues, relationPropertyCache);
        return this.createRelationRow(res);
    }

    protected abstract TnRelationRowCreationResource createResourceForRow(ResultSet var1, TnRelationPropertyType var2, Map<String, String> var3, Map<String, Object> var4, Map<String, Map<String, TnPropertyMapping>> var5) throws SQLException;

    protected Object createRelationRow(TnRelationRowCreationResource res) throws SQLException {
        if (!res.hasPropertyCacheElement()) {
            return null;
        }
        this.setupRelationKeyValue(res);
        this.setupRelationAllValue(res);
        return res.getRow();
    }

    protected void setupRelationKeyValue(TnRelationRowCreationResource res) {
        TnRelationPropertyType rpt = res.getRelationPropertyType();
        TnBeanMetaData relBmd = rpt.getBeanMetaData();
        for (int i = 0; i < rpt.getKeySize(); ++i) {
            Object value;
            String columnName = rpt.getMyKey(i) + res.getBaseSuffix();
            if (!res.containsSelectColumn(columnName)) continue;
            if (!res.hasRowInstance()) {
                res.setRow(this.newRelationRow(rpt));
            }
            if (!res.containsRelKeyValueIfExists(columnName) || (value = res.extractRelKeyValue(columnName)) == null) continue;
            String yourKey = rpt.getYourKey(i);
            TnPropertyType pt = relBmd.getPropertyTypeByColumnName(yourKey);
            DfPropertyDesc pd = pt.getPropertyDesc();
            pd.setValue(res.getRow(), value);
        }
    }

    protected abstract void setupRelationAllValue(TnRelationRowCreationResource var1) throws SQLException;

    protected boolean isValidRelationPerPropertyLoop(TnRelationRowCreationResource res) throws SQLException {
        return true;
    }

    protected boolean isValidRelationAfterPropertyLoop(TnRelationRowCreationResource res) throws SQLException {
        if (res.isCreateDeadLink()) {
            return true;
        }
        return res.hasValidValueCount();
    }

    protected void setupRelationProperty(TnRelationRowCreationResource res) throws SQLException {
        String columnName = res.buildRelationColumnName();
        if (!res.hasRowInstance()) {
            res.setRow(this.newRelationRow(res));
        }
        this.registerRelationValue(res, columnName);
    }

    protected abstract void registerRelationValue(TnRelationRowCreationResource var1, String var2) throws SQLException;

    protected void registerRelationValidValue(TnRelationRowCreationResource res, TnPropertyType pt, Object value) throws SQLException {
        res.incrementValidValueCount();
        DfPropertyDesc pd = pt.getPropertyDesc();
        pd.setValue(res.getRow(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextRelationRow(TnRelationRowCreationResource res) throws SQLException {
        TnBeanMetaData nextBmd = res.getRelationBeanMetaData();
        Object row = res.getRow();
        res.backupRelationPropertyType();
        res.incrementCurrentRelationNestLevel();
        try {
            for (int i = 0; i < nextBmd.getRelationPropertyTypeSize(); ++i) {
                TnRelationPropertyType nextRpt = nextBmd.getRelationPropertyType(i);
                this.setupNextRelationRowElement(res, row, nextRpt);
            }
        }
        finally {
            res.setRow(row);
            res.restoreRelationPropertyType();
            res.decrementCurrentRelationNestLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextRelationRowElement(TnRelationRowCreationResource res, Object row, TnRelationPropertyType nextRpt) throws SQLException {
        if (nextRpt == null) {
            return;
        }
        res.clearRowInstance();
        res.setRelationPropertyType(nextRpt);
        String baseSuffix = res.getRelationNoSuffix();
        String additionalRelationNoSuffix = this.buildRelationNoSuffix(nextRpt);
        res.backupSuffixAndPrepare(baseSuffix, additionalRelationNoSuffix);
        try {
            Object relationRow = this.createRelationRow(res);
            if (relationRow != null) {
                nextRpt.getPropertyDesc().setValue(row, relationRow);
            }
        }
        finally {
            res.restoreSuffix();
        }
    }

    @Override
    public Map<String, Map<String, TnPropertyMapping>> createPropertyCache(Map<String, String> selectColumnMap, TnBeanMetaData bmd) throws SQLException {
        Map<String, Map<String, TnPropertyMapping>> relationPropertyCache = this.newRelationPropertyCache();
        for (int i = 0; i < bmd.getRelationPropertyTypeSize(); ++i) {
            TnRelationPropertyType rpt = bmd.getRelationPropertyType(i);
            String baseSuffix = "";
            String relationNoSuffix = this.buildRelationNoSuffix(rpt);
            TnRelationRowCreationResource res = this.createResourceForPropertyCache(rpt, selectColumnMap, relationPropertyCache, "", relationNoSuffix, this.getLimitRelationNestLevel());
            if (rpt == null) continue;
            this.setupPropertyCache(res);
        }
        return relationPropertyCache;
    }

    protected abstract TnRelationRowCreationResource createResourceForPropertyCache(TnRelationPropertyType var1, Map<String, String> var2, Map<String, Map<String, TnPropertyMapping>> var3, String var4, String var5, int var6) throws SQLException;

    protected abstract void setupPropertyCache(TnRelationRowCreationResource var1) throws SQLException;

    protected void setupPropertyCacheElement(TnRelationRowCreationResource res) throws SQLException {
        String columnName = res.buildRelationColumnName();
        if (!res.containsSelectColumn(columnName)) {
            return;
        }
        res.savePropertyCacheElement();
    }

    protected void setupNextPropertyCache(TnRelationRowCreationResource res, TnBeanMetaData nextBmd) throws SQLException {
        for (int i = 0; i < nextBmd.getRelationPropertyTypeSize(); ++i) {
            TnRelationPropertyType nextNextRpt = nextBmd.getRelationPropertyType(i);
            res.setRelationPropertyType(nextNextRpt);
            this.setupNextPropertyCacheElement(res, nextNextRpt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextPropertyCacheElement(TnRelationRowCreationResource res, TnRelationPropertyType nextNextRpt) throws SQLException {
        String baseSuffix = res.getRelationNoSuffix();
        String additionalRelationNoSuffix = this.buildRelationNoSuffix(nextNextRpt);
        res.backupSuffixAndPrepare(baseSuffix, additionalRelationNoSuffix);
        try {
            this.setupPropertyCache(res);
        }
        finally {
            res.restoreSuffix();
        }
    }

    protected Map<String, Map<String, TnPropertyMapping>> newRelationPropertyCache() {
        return StringKeyMap.createAsCaseInsensitive();
    }

    protected String buildRelationNoSuffix(TnRelationPropertyType rpt) {
        return "_" + rpt.getRelationNo();
    }

    protected Object newRelationRow(TnRelationRowCreationResource res) {
        return this.newRelationRow(res.getRelationPropertyType());
    }

    protected Object newRelationRow(TnRelationPropertyType rpt) {
        return DfReflectionUtil.newInstance(rpt.getPropertyDesc().getPropertyType());
    }

    protected boolean isTargetRelation(TnRelationRowCreationResource res) throws SQLException {
        return true;
    }

    protected abstract boolean isCreateDeadLink();

    protected abstract int getLimitRelationNestLevel();
}

