/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.rshandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.Entity;
import org.seasar.robot.dbflute.resource.ResourceContext;
import org.seasar.robot.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyMapping;
import org.seasar.robot.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.robot.dbflute.s2dao.rowcreator.TnRelationRowCreator;
import org.seasar.robot.dbflute.s2dao.rowcreator.TnRowCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnAbstractBeanResultSetHandler
implements TnResultSetHandler {
    private TnBeanMetaData beanMetaData;
    protected TnRowCreator rowCreator;
    protected TnRelationRowCreator relationRowCreator;

    public TnAbstractBeanResultSetHandler(TnBeanMetaData beanMetaData, TnRowCreator rowCreator, TnRelationRowCreator relationRowCreator) {
        this.beanMetaData = beanMetaData;
        this.rowCreator = rowCreator;
        this.relationRowCreator = relationRowCreator;
    }

    protected Map<String, TnPropertyMapping> createPropertyCache(Map<String, String> selectColumnSet) throws SQLException {
        return this.rowCreator.createPropertyCache(selectColumnSet, this.beanMetaData);
    }

    protected Object createRow(ResultSet rs, Map<String, TnPropertyMapping> propertyCache) throws SQLException {
        Class<?> beanClass = this.beanMetaData.getBeanClass();
        return this.rowCreator.createRow(rs, propertyCache, beanClass);
    }

    protected Map<String, Map<String, TnPropertyMapping>> createRelationPropertyCache(Map<String, String> selectColumnMap) throws SQLException {
        return this.relationRowCreator.createPropertyCache(selectColumnMap, this.beanMetaData);
    }

    protected Object createRelationRow(ResultSet rs, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Object> relKeyValues, Map<String, Map<String, TnPropertyMapping>> relationPropertyCache) throws SQLException {
        return this.relationRowCreator.createRelationRow(rs, rpt, selectColumnMap, relKeyValues, relationPropertyCache);
    }

    protected void postCreateRow(Object row) {
        if (row instanceof Entity) {
            ((Entity)row).clearModifiedInfo();
        } else {
            TnBeanMetaData bmd = this.getBeanMetaData();
            Set<String> names = bmd.getModifiedPropertyNames(row);
            names.clear();
        }
    }

    protected Map<String, String> createSelectColumnMap(ResultSet rs) throws SQLException {
        return ResourceContext.createSelectColumnMap(rs);
    }

    public TnBeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }
}

