/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.carrot2.core.Controller;
import org.carrot2.core.ControllerUtils;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.IProcessingComponentManager;
import org.carrot2.core.ProcessingComponentBase;
import org.carrot2.core.ProcessingComponentConfiguration;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.Pair;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.BindableDescriptorBuilder;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;

public class CachingProcessingComponentManager
implements IProcessingComponentManager,
Controller.IControllerStatisticsProvider {
    final IProcessingComponentManager delegate;
    private final Map<Pair<Class<? extends IProcessingComponent>, String>, InputOutputAttributeDescriptors> cachedComponentAttributeDescriptors = Maps.newHashMap();
    final Set<Class<? extends IProcessingComponent>> cachedComponentClasses;
    private Cache<AttributeMapCacheKey, Map<String, Object>> cache;
    static final String CACHE_MISSES = "cache.misses";
    static final String CACHE_HITS_TOTAL = "cache.hits.total";
    private static final String COMPONENT_CLASS_KEY = CachingProcessingComponentManager.class.getName() + ".componentClass";
    private static final String COMPONENT_ID_KEY = CachingProcessingComponentManager.class.getName() + ".componentId";

    public CachingProcessingComponentManager(IProcessingComponentManager delegate, Class<? extends IProcessingComponent> ... cachedComponentClasses) {
        this.delegate = delegate;
        this.cachedComponentClasses = ImmutableSet.copyOf((Object[])cachedComponentClasses);
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).recordStats().build();
    }

    @Override
    public void init(IControllerContext context, Map<String, Object> attributes, ProcessingComponentConfiguration ... configurations) {
        this.delegate.init(context, attributes, configurations);
    }

    @Override
    public IProcessingComponent prepare(Class<? extends IProcessingComponent> clazz, String id, Map<String, Object> inputAttributes, Map<String, Object> outputAttributes) {
        for (Class<? extends IProcessingComponent> cachedClass : this.cachedComponentClasses) {
            if (!cachedClass.isAssignableFrom(clazz)) continue;
            return new CachedProcessingComponent(clazz, id, inputAttributes, outputAttributes);
        }
        return this.delegate.prepare(clazz, id, inputAttributes, outputAttributes);
    }

    @Override
    public void recycle(IProcessingComponent component, String id) {
        if (!(component instanceof CachedProcessingComponent)) {
            this.delegate.recycle(component, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            this.delegate.dispose();
            if (this.cache != null) {
                this.cache.invalidateAll();
            }
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public Map<String, Object> getStatistics() {
        CacheStats cacheStats = this.cache.stats();
        HashMap stats = Maps.newHashMap();
        if (this.delegate instanceof Controller.IControllerStatisticsProvider) {
            stats.putAll(((Controller.IControllerStatisticsProvider)((Object)this.delegate)).getStatistics());
        }
        stats.put(CACHE_MISSES, cacheStats.missCount());
        stats.put(CACHE_HITS_TOTAL, cacheStats.hitCount());
        return stats;
    }

    private static final class InputOutputAttributeDescriptors {
        final Map<String, AttributeDescriptor> inputProcessingDescriptors;
        final Map<String, AttributeDescriptor> outputDescriptors;

        InputOutputAttributeDescriptors(Map<String, AttributeDescriptor> inputDescriptors, Map<String, AttributeDescriptor> outputDescriptors) {
            this.inputProcessingDescriptors = inputDescriptors;
            this.outputDescriptors = outputDescriptors;
        }
    }

    private final class ValueProducer
    implements Callable<Map<String, Object>> {
        private final AttributeMapCacheKey key;

        public ValueProducer(AttributeMapCacheKey key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> call() throws Exception {
            Map inputProcessingAttributes = this.key.inputProcessingAttributes;
            Class componentClass = (Class)inputProcessingAttributes.get(COMPONENT_CLASS_KEY);
            String componentId = (String)inputProcessingAttributes.get(COMPONENT_ID_KEY);
            IProcessingComponent component = null;
            try {
                HashMap attributes = Maps.newHashMap();
                component = CachingProcessingComponentManager.this.delegate.prepare(componentClass, componentId, this.key.inputAttributes, attributes);
                ControllerUtils.performProcessing(component, inputProcessingAttributes, attributes);
                HashMap hashMap = attributes;
                if (component != null) {
                    CachingProcessingComponentManager.this.delegate.recycle(component, componentId);
                }
                return hashMap;
            }
            catch (Throwable throwable) {
                if (component != null) {
                    CachingProcessingComponentManager.this.delegate.recycle(component, componentId);
                }
                throw throwable;
            }
        }
    }

    private static final class AttributeMapCacheKey {
        private Map<String, Object> inputProcessingAttributes;
        private int hashCode;
        private Map<String, Object> inputAttributes;

        private AttributeMapCacheKey(Map<String, Object> inputProcessingAttributes, Map<String, Object> inputAttributes) {
            assert (inputProcessingAttributes != null && inputProcessingAttributes.size() > 0);
            this.inputProcessingAttributes = Collections.unmodifiableMap(inputProcessingAttributes);
            this.hashCode = inputProcessingAttributes.hashCode();
            this.inputAttributes = inputAttributes;
        }

        public boolean equals(Object obj) {
            boolean result;
            if (!(obj instanceof AttributeMapCacheKey)) {
                return false;
            }
            boolean bl = result = obj.hashCode() == this.hashCode;
            if (result) assert (((AttributeMapCacheKey)obj).inputProcessingAttributes.equals(this.inputProcessingAttributes));
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private final class CachedProcessingComponent
    extends ProcessingComponentBase {
        private final Class<? extends IProcessingComponent> componentClass;
        private final String componentId;
        private final Map<String, Object> inputAttributes;
        private final Map<String, Object> outputAttributes;

        CachedProcessingComponent(Class<? extends IProcessingComponent> componentClass, String componentId, Map<String, Object> inputAttributes, Map<String, Object> outputAttributes) {
            this.componentClass = componentClass;
            this.inputAttributes = inputAttributes;
            this.outputAttributes = outputAttributes;
            this.componentId = componentId;
        }

        @Override
        public void process() throws ProcessingException {
            InputOutputAttributeDescriptors descriptors = this.prepareAttributeDescriptors();
            this.inputAttributes.putAll(this.outputAttributes);
            Map<String, Object> inputProcessingAttributes = this.getAttributesForDescriptors(descriptors.inputProcessingDescriptors, this.inputAttributes);
            inputProcessingAttributes.put(COMPONENT_CLASS_KEY, this.componentClass);
            inputProcessingAttributes.put(COMPONENT_ID_KEY, this.componentId);
            AttributeMapCacheKey key = new AttributeMapCacheKey(inputProcessingAttributes, this.inputAttributes);
            try {
                Map processingResult = (Map)CachingProcessingComponentManager.this.cache.get((Object)key, (Callable)new ValueProducer(key));
                this.outputAttributes.putAll(this.getAttributesForDescriptors(descriptors.outputDescriptors, processingResult));
            }
            catch (UncheckedExecutionException e) {
                throw ExceptionUtils.wrapAs(ProcessingException.class, e.getCause());
            }
            catch (ExecutionException e) {
                throw ExceptionUtils.wrapAs(ProcessingException.class, e.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputOutputAttributeDescriptors prepareAttributeDescriptors() {
            InputOutputAttributeDescriptors descriptors = null;
            Map map = CachingProcessingComponentManager.this.cachedComponentAttributeDescriptors;
            synchronized (map) {
                descriptors = (InputOutputAttributeDescriptors)CachingProcessingComponentManager.this.cachedComponentAttributeDescriptors.get(new Pair<Class<? extends IProcessingComponent>, String>(this.componentClass, this.componentId));
                if (descriptors == null) {
                    IProcessingComponent component = null;
                    try {
                        component = CachingProcessingComponentManager.this.delegate.prepare(this.componentClass, this.componentId, this.inputAttributes, Maps.newHashMap());
                        descriptors = new InputOutputAttributeDescriptors(BindableDescriptorBuilder.buildDescriptor((Object)component).only((Class[])new Class[]{Input.class, Processing.class}).flatten().attributeDescriptors, BindableDescriptorBuilder.buildDescriptor((Object)component).only((Class[])new Class[]{Output.class}).flatten().attributeDescriptors);
                        CachingProcessingComponentManager.this.cachedComponentAttributeDescriptors.put(new Pair<Class<? extends IProcessingComponent>, String>(this.componentClass, this.componentId), descriptors);
                        if (component != null) {
                            CachingProcessingComponentManager.this.delegate.recycle(component, this.componentId);
                        }
                    }
                    catch (Throwable throwable) {
                        if (component != null) {
                            CachingProcessingComponentManager.this.delegate.recycle(component, this.componentId);
                        }
                        throw throwable;
                    }
                }
            }
            return descriptors;
        }

        Map<String, Object> getAttributesForDescriptors(Map<String, AttributeDescriptor> inputDescriptors, Map<String, Object> attributes) {
            HashMap attributesForDrescriptors = Maps.newHashMap();
            for (AttributeDescriptor descriptor : inputDescriptors.values()) {
                if (!attributes.containsKey(descriptor.key)) continue;
                attributesForDrescriptors.put(descriptor.key, attributes.get(descriptor.key));
            }
            return attributesForDrescriptors;
        }
    }
}

