/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.output.metrics;

import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.Processing;
import org.carrot2.output.metrics.IdealPartitioningBasedMetric;
import org.carrot2.util.MathUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;

@Bindable
public class PrecisionRecallMetric
extends IdealPartitioningBasedMetric {
    public static final String BEST_F_MEASURE_PARTITION = "best-f-measure-partition";
    @Processing
    @Output
    @Attribute
    public Double weightedAveragePrecision;
    @Processing
    @Output
    @Attribute
    public Double weightedAverageRecall;
    @Processing
    @Output
    @Attribute
    public Double weightedAverageFMeasure;
    @Processing
    @Output
    @Attribute
    public Map<Object, Double> precisionByPartition;
    @Processing
    @Output
    @Attribute
    public Map<Object, Double> recallByPartition;
    @Processing
    @Output
    @Attribute
    public Map<Object, Double> fMeasureByPartition;
    @Processing
    @Input
    @Attribute
    public boolean enabled = true;
    @Processing
    @Input
    @Attribute(key="documents")
    public List<Document> documents;
    @Processing
    @Input
    @Attribute(key="clusters")
    public List<Cluster> clusters;

    @Override
    public void calculate() {
        int partitionCount = this.getPartitionsCount(this.documents);
        if (partitionCount == 0) {
            return;
        }
        if (this.clusters.size() == 0) {
            return;
        }
        SetMultimap<Object, Document> documentsByPartition = this.getDocumentsByPartition(this.documents);
        Set<Object> partitions = this.getPartitions(this.documents);
        this.precisionByPartition = Maps.newHashMap();
        this.recallByPartition = Maps.newHashMap();
        this.fMeasureByPartition = Maps.newHashMap();
        double recallSum = 0.0;
        double precisionSum = 0.0;
        double fMeasureSum = 0.0;
        int partitionDocumentsCountSum = 0;
        for (Object partition : partitions) {
            Set partitionDocuments = documentsByPartition.get(partition);
            int partitionDocumentsCount = partitionDocuments.size();
            double partitionFMeasure = 0.0;
            double partitionPrecision = 0.0;
            double partitionRecall = 0.0;
            Cluster bestFMeasureCluster = null;
            for (Cluster cluster : this.clusters) {
                double recall;
                List<Document> clusterDocuments = cluster.getAllDocuments();
                if (cluster.isOtherTopics() || clusterDocuments.size() == 0) continue;
                HashSet commonDocuments = Sets.newHashSet((Iterable)partitionDocuments);
                commonDocuments.retainAll(clusterDocuments);
                double precision = (double)commonDocuments.size() / (double)clusterDocuments.size();
                double fMeasure = MathUtils.harmonicMean(precision, recall = (double)commonDocuments.size() / (double)partitionDocumentsCount);
                if (!(fMeasure > partitionFMeasure)) continue;
                partitionFMeasure = fMeasure;
                partitionPrecision = precision;
                partitionRecall = recall;
                bestFMeasureCluster = cluster;
            }
            recallSum += partitionRecall * (double)partitionDocumentsCount;
            precisionSum += partitionPrecision * (double)partitionDocumentsCount;
            fMeasureSum += partitionFMeasure * (double)partitionDocumentsCount;
            partitionDocumentsCountSum += partitionDocumentsCount;
            this.recallByPartition.put(partition, partitionRecall);
            this.precisionByPartition.put(partition, partitionPrecision);
            this.fMeasureByPartition.put(partition, partitionFMeasure);
            if (bestFMeasureCluster == null) continue;
            bestFMeasureCluster.setAttribute(BEST_F_MEASURE_PARTITION, partition);
        }
        this.weightedAveragePrecision = precisionSum / (double)partitionDocumentsCountSum;
        this.weightedAverageRecall = recallSum / (double)partitionDocumentsCountSum;
        this.weightedAverageFMeasure = fMeasureSum / (double)partitionDocumentsCountSum;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

