/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.carrot2.core.Document;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineBase;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.UniqueFieldPredicate;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable
public abstract class MultipageSearchEngine
extends SearchEngineBase {
    @Processing
    @Input
    @Attribute(key="search-mode")
    @Level(value=AttributeLevel.ADVANCED)
    @Label(value="Search Mode")
    @Group(value="Data source paging")
    public SearchMode searchMode = SearchMode.SPECULATIVE;

    protected void process(MultipageSearchEngineMetadata metadata, ExecutorService executor) throws ProcessingException {
        SearchEngineResponse[] responses = this.runQuery(this.query, this.start, this.results, metadata, executor);
        this.compressed = false;
        if (responses.length > 0) {
            this.documents = new ArrayList(Math.min(this.results, metadata.maxResultIndex));
            this.collectDocuments(this.documents, responses);
            Iterator i = this.documents.iterator();
            UniqueFieldPredicate p = new UniqueFieldPredicate("url");
            while (i.hasNext()) {
                if (p.apply(i.next())) continue;
                i.remove();
            }
            this.resultsTotal = responses[0].getResultsTotal();
            for (int j = 0; j < responses.length; ++j) {
                String compression = (String)responses[j].metadata.get("compression");
                if (compression == null || !"gzip".contains(compression)) continue;
                this.compressed = true;
            }
        } else {
            this.documents = Collections.emptyList();
            this.resultsTotal = 0L;
        }
    }

    protected abstract Callable<SearchEngineResponse> createFetcher(SearchRange var1);

    protected final void collectDocuments(Collection<Document> collector, SearchEngineResponse[] responses) {
        for (SearchEngineResponse response : responses) {
            collector.addAll(response.results);
        }
    }

    protected final SearchEngineResponse[] runQuery(String query, int start, int results, MultipageSearchEngineMetadata metadata, ExecutorService executor) throws ProcessingException {
        this.statistics.incrQueryCount();
        SearchRange[] buckets = SearchRange.getSearchRanges(start, results, metadata.maxResultIndex, metadata.resultsPerPage, metadata.incrementByPage);
        if (query == null || query.trim().equals("") || buckets.length == 0) {
            return new SearchEngineResponse[0];
        }
        try {
            ArrayList<SearchEngineResponse> responses = new ArrayList<SearchEngineResponse>(buckets.length);
            if (buckets.length == 1 || this.searchMode == SearchMode.CONSERVATIVE) {
                SearchEngineResponse response = this.createFetcher(buckets[0]).call();
                long resultsTotal = response.getResultsTotal();
                responses.add(response);
                if (buckets.length == 1) {
                    return responses.toArray(new SearchEngineResponse[responses.size()]);
                }
                if (resultsTotal != -1L && resultsTotal < (long)results) {
                    buckets = SearchRange.getSearchRanges(buckets[0].results, (int)resultsTotal, metadata.maxResultIndex, metadata.resultsPerPage, metadata.incrementByPage);
                }
            }
            ArrayList<Callable<SearchEngineResponse>> fetchers = new ArrayList<Callable<SearchEngineResponse>>(buckets.length);
            for (SearchRange r : buckets) {
                fetchers.add(this.createFetcher(r));
            }
            List futures = executor.invokeAll(fetchers);
            for (Future future : futures) {
                if (future.isCancelled()) continue;
                responses.add((SearchEngineResponse)future.get());
            }
            return responses.toArray(new SearchEngineResponse[responses.size()]);
        }
        catch (IOException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            return new SearchEngineResponse[0];
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new ProcessingException(cause.getMessage(), e);
        }
    }

    public static enum SearchMode {
        CONSERVATIVE,
        SPECULATIVE;

    }

    protected static final class SearchRange {
        private static final SearchRange[] EMPTY_RANGE = new SearchRange[0];
        public final int start;
        public final int results;

        public SearchRange(int start, int results) {
            this.start = start;
            this.results = results;
        }

        public static SearchRange[] getSearchRanges(int start, int results, int maxIndex, int resultsPerPage, boolean incrementByPage) {
            results = Math.max(results, 0);
            start = Math.max(start, 0);
            int startIndex = Math.min(start * (incrementByPage ? resultsPerPage : 1), maxIndex);
            int endIndex = Math.min(start * (incrementByPage ? resultsPerPage : 1) + results, maxIndex);
            int resultsNeeded = endIndex - startIndex;
            if (resultsNeeded == 0) {
                return EMPTY_RANGE;
            }
            int lastBucketSize = resultsNeeded % resultsPerPage;
            int bucketsNeeded = resultsNeeded / resultsPerPage + (lastBucketSize > 0 ? 1 : 0);
            SearchRange[] buckets = new SearchRange[bucketsNeeded];
            for (int i = 0; i < buckets.length; ++i) {
                int window = Math.min(resultsPerPage, endIndex - startIndex);
                buckets[i] = new SearchRange(incrementByPage ? start + i : startIndex, window);
                startIndex += window;
            }
            return buckets;
        }
    }

    protected abstract class SearchEngineResponseCallable
    implements Callable<SearchEngineResponse> {
        protected SearchEngineResponseCallable() {
        }

        @Override
        public final SearchEngineResponse call() throws Exception {
            MultipageSearchEngine.this.statistics.incrPageRequestCount();
            SearchEngineResponse response = this.search();
            MultipageSearchEngine.this.afterFetch(response);
            return response;
        }

        public abstract SearchEngineResponse search() throws Exception;
    }
}

