/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class SearchEngineBaseDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.SearchEngineBase";
    public final String prefix = "SearchEngineBase";
    public final String title = "A base class facilitating implementation of <code>IDocumentSource</code>s wrapping external search engines with remote/ network-based interfaces";
    public final String label = "";
    public final String description = "The base class defines the common attribute fields used by more specific base classes and concrete implementations.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "SearchEngineBase";
    }

    public String getTitle() {
        return "A base class facilitating implementation of <code>IDocumentSource</code>s wrapping external search engines with remote/ network-based interfaces";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "The base class defines the common attribute fields used by more specific base classes and concrete implementations.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(SearchEngineBaseDescriptor.attributes.start);
        ownAttrs.add(SearchEngineBaseDescriptor.attributes.results);
        ownAttrs.add(SearchEngineBaseDescriptor.attributes.query);
        ownAttrs.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        ownAttrs.add(SearchEngineBaseDescriptor.attributes.documents);
        ownAttrs.add(SearchEngineBaseDescriptor.attributes.compressed);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(SearchEngineBaseDescriptor.attributes.start);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.results);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.query);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.documents);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.compressed);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder start(int value) {
            this.map.put("start", value);
            return this;
        }

        public AttributeBuilder results(int value) {
            this.map.put("results", value);
            return this;
        }

        public AttributeBuilder query(String value) {
            this.map.put("query", value);
            return this;
        }

        public long resultsTotal() {
            return (Long)this.map.get("results-total");
        }

        public Collection<Document> documents() {
            return (Collection)this.map.get("documents");
        }

        public boolean compressed() {
            return (Boolean)this.map.get("SearchEngineBase.compressed");
        }
    }

    public static final class Attributes {
        public final AttributeInfo start;
        public final AttributeInfo results;
        public final AttributeInfo query;
        public final AttributeInfo resultsTotal;
        public final AttributeInfo documents;
        public final AttributeInfo compressed;

        private Attributes() {
            this.start = new AttributeInfo("start", "org.carrot2.source.SearchEngineBase", "start", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.start);
            this.results = new AttributeInfo("results", "org.carrot2.source.SearchEngineBase", "results", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.results);
            this.query = new AttributeInfo("query", "org.carrot2.source.SearchEngineBase", "query", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.query);
            this.resultsTotal = new AttributeInfo("results-total", "org.carrot2.source.SearchEngineBase", "resultsTotal", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.resultsTotal);
            this.documents = new AttributeInfo("documents", "org.carrot2.source.SearchEngineBase", "documents", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.compressed = new AttributeInfo("SearchEngineBase.compressed", "org.carrot2.source.SearchEngineBase", "compressed", "Indicates whether the search engine returned a compressed result stream.", "Compression used", "Indicates whether the search engine returned a compressed result stream", null, "Search result information", null, null);
        }
    }

    public static class Keys {
        public static final String START = "start";
        public static final String RESULTS = "results";
        public static final String QUERY = "query";
        public static final String RESULTS_TOTAL = "results-total";
        public static final String DOCUMENTS = "documents";
        public static final String COMPRESSED = "SearchEngineBase.compressed";

        protected Keys() {
        }
    }
}

