/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.ambient;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.source.ambient.AmbientDocumentSource;
import org.carrot2.source.ambient.FubDocumentSourceDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class AmbientDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.ambient.AmbientDocumentSource";
    public final String prefix = "AmbientDocumentSource";
    public final String title = "Serves documents from the Ambient test set";
    public final String label = "";
    public final String description = "Ambient (AMBIgous ENTries) is a data set designed for evaluating subtopic information retrieval. It consists of 44 topics, each with a set of subtopics and a list of 100 ranked documents. For more information, please see <a href=\"http://credo.fub.it/ambient/\">Ambient home page</a>.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "AmbientDocumentSource";
    }

    public String getTitle() {
        return "Serves documents from the Ambient test set";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "Ambient (AMBIgous ENTries) is a data set designed for evaluating subtopic information retrieval. It consists of 44 topics, each with a set of subtopics and a list of 100 ranked documents. For more information, please see <a href=\"http://credo.fub.it/ambient/\">Ambient home page</a>.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(AmbientDocumentSourceDescriptor.attributes.topic);
        ownAttrs.add(AmbientDocumentSourceDescriptor.attributes.results);
        ownAttrs.add(AmbientDocumentSourceDescriptor.attributes.resultsTotal);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(AmbientDocumentSourceDescriptor.attributes.topic);
        allAttrs.add(AmbientDocumentSourceDescriptor.attributes.results);
        allAttrs.add(AmbientDocumentSourceDescriptor.attributes.resultsTotal);
        allAttrs.add(FubDocumentSourceDescriptor.attributes.documents);
        allAttrs.add(FubDocumentSourceDescriptor.attributes.topicIds);
        allAttrs.add(FubDocumentSourceDescriptor.attributes.query);
        allAttrs.add(FubDocumentSourceDescriptor.attributes.minTopicSize);
        allAttrs.add(FubDocumentSourceDescriptor.attributes.includeDocumentsWithoutTopic);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder
    extends FubDocumentSourceDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder topic(AmbientDocumentSource.AmbientTopic value) {
            this.map.put("AmbientDocumentSource.topic", (Object)value);
            return this;
        }

        public AttributeBuilder topic(Class<? extends AmbientDocumentSource.AmbientTopic> clazz) {
            this.map.put("AmbientDocumentSource.topic", clazz);
            return this;
        }

        public AttributeBuilder results(int value) {
            this.map.put("results", value);
            return this;
        }

        public long resultsTotal() {
            return (Long)this.map.get("results-total");
        }
    }

    public static final class Attributes {
        public final AttributeInfo topic = new AttributeInfo("AmbientDocumentSource.topic", "org.carrot2.source.ambient.AmbientDocumentSource", "topic", "Ambient Topic. The Ambient Topic to load documents from.", null, "Ambient Topic", "The Ambient Topic to load documents from.", "Topic ID", AttributeLevel.BASIC, null);
        public final AttributeInfo results;
        public final AttributeInfo resultsTotal;

        private Attributes() {
            this.results = new AttributeInfo("results", "org.carrot2.source.ambient.AmbientDocumentSource", "results", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.results);
            this.resultsTotal = new AttributeInfo("results-total", "org.carrot2.source.ambient.AmbientDocumentSource", "resultsTotal", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.resultsTotal);
        }
    }

    public static class Keys
    extends FubDocumentSourceDescriptor.Keys {
        public static final String TOPIC = "AmbientDocumentSource.topic";
        public static final String RESULTS = "results";
        public static final String RESULTS_TOTAL = "results-total";

        protected Keys() {
        }
    }
}

