/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.ambient;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class FubDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.ambient.FubDocumentSource";
    public final String prefix = "FubDocumentSource";
    public final String title = "A base document source for test collections developed at Fondazione Ugo Bordoni";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "FubDocumentSource";
    }

    public String getTitle() {
        return "A base document source for test collections developed at Fondazione Ugo Bordoni";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(FubDocumentSourceDescriptor.attributes.documents);
        ownAttrs.add(FubDocumentSourceDescriptor.attributes.topicIds);
        ownAttrs.add(FubDocumentSourceDescriptor.attributes.query);
        ownAttrs.add(FubDocumentSourceDescriptor.attributes.minTopicSize);
        ownAttrs.add(FubDocumentSourceDescriptor.attributes.includeDocumentsWithoutTopic);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(FubDocumentSourceDescriptor.attributes.documents);
        allAttrs.add(FubDocumentSourceDescriptor.attributes.topicIds);
        allAttrs.add(FubDocumentSourceDescriptor.attributes.query);
        allAttrs.add(FubDocumentSourceDescriptor.attributes.minTopicSize);
        allAttrs.add(FubDocumentSourceDescriptor.attributes.includeDocumentsWithoutTopic);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public List<Document> documents() {
            return (List)this.map.get("documents");
        }

        public Set<Object> topicIds() {
            return (Set)this.map.get("FubDocumentSource.topicIds");
        }

        public String query() {
            return (String)this.map.get("query");
        }

        public AttributeBuilder minTopicSize(int value) {
            this.map.put("FubDocumentSource.minTopicSize", value);
            return this;
        }

        public AttributeBuilder includeDocumentsWithoutTopic(boolean value) {
            this.map.put("FubDocumentSource.includeDocumentsWithoutTopic", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo documents;
        public final AttributeInfo topicIds;
        public final AttributeInfo query;
        public final AttributeInfo minTopicSize;
        public final AttributeInfo includeDocumentsWithoutTopic;

        private Attributes() {
            this.documents = new AttributeInfo("documents", "org.carrot2.source.ambient.FubDocumentSource", "documents", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.topicIds = new AttributeInfo("FubDocumentSource.topicIds", "org.carrot2.source.ambient.FubDocumentSource", "topicIds", "Topics and subtopics covered in the output documents. The set is computed for the\noutput {@link org.carrot2.source.ambient.FubDocumentSource#documents} and it may vary for the same main topic based e.g. on the\nrequested number of requested results or {@link org.carrot2.source.ambient.FubDocumentSource#minTopicSize}.", null, "Topics and subtopics covered in the output documents", "The set is computed for the output <code>org.carrot2.source.ambient.FubDocumentSource.documents</code> and it may vary for the same main topic based e.g. on the requested number of requested results or <code>org.carrot2.source.ambient.FubDocumentSource.minTopicSize</code>.", "Topic ID", AttributeLevel.ADVANCED, null);
            this.query = new AttributeInfo("query", "org.carrot2.source.ambient.FubDocumentSource", "query", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.query);
            this.minTopicSize = new AttributeInfo("FubDocumentSource.minTopicSize", "org.carrot2.source.ambient.FubDocumentSource", "minTopicSize", "Minimum topic size. Documents belonging to a topic with fewer documents than\nminimum topic size will not be returned.", null, "Minimum topic size", "Documents belonging to a topic with fewer documents than minimum topic size will not be returned.", "Filtering", AttributeLevel.MEDIUM, null);
            this.includeDocumentsWithoutTopic = new AttributeInfo("FubDocumentSource.includeDocumentsWithoutTopic", "org.carrot2.source.ambient.FubDocumentSource", "includeDocumentsWithoutTopic", "Include documents without topics.", null, "Include documents without topics", null, "Filtering", AttributeLevel.MEDIUM, null);
        }
    }

    public static class Keys {
        public static final String DOCUMENTS = "documents";
        public static final String TOPIC_IDS = "FubDocumentSource.topicIds";
        public static final String QUERY = "query";
        public static final String MIN_TOPIC_SIZE = "FubDocumentSource.minTopicSize";
        public static final String INCLUDE_DOCUMENTS_WITHOUT_TOPIC = "FubDocumentSource.includeDocumentsWithoutTopic";

        protected Keys() {
        }
    }
}

