/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.ambient;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.core.ProcessingException;
import org.carrot2.source.ambient.AmbientDocumentSource;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.MapUtils;
import org.carrot2.util.resource.ClassResource;
import org.carrot2.util.resource.IResource;

class FubTestCollection {
    int topicCount;
    final Map<Integer, List<Document>> documentsByTopicId;
    final Map<String, Integer> subtopicSizes;
    final Map<String, String> subtopicLabels;

    public FubTestCollection(String basePath) {
        int[][] resultSubtopicIds = this.loadSubtopicMapping(new ClassResource(AmbientDocumentSource.class, basePath + "/STRel.txt"));
        this.documentsByTopicId = FubTestCollection.loadDocuments(new ClassResource(AmbientDocumentSource.class, basePath + "/results.txt"), resultSubtopicIds);
        this.subtopicSizes = FubTestCollection.prepareSubtopicSizes(resultSubtopicIds);
        this.subtopicLabels = FubTestCollection.loadSubtopicLabels(new ClassResource(AmbientDocumentSource.class, basePath + "/subTopics.txt"));
    }

    protected int getTopicCount() {
        return this.topicCount;
    }

    protected List<Document> getDocumentsForTopic(int topicId, int requestedResults, final int minTopicSize, final boolean includeDocumentsWithoutTopic) throws ProcessingException {
        ArrayList documents = Lists.newArrayList((Iterable)Collections2.filter((Collection)this.documentsByTopicId.get(topicId), (Predicate)new Predicate<Document>(){

            public boolean apply(Document document) {
                String documentTopic = FubTestCollection.getTopic(document);
                return FubTestCollection.this.subtopicSizes.get(documentTopic) >= minTopicSize && (includeDocumentsWithoutTopic || !documentTopic.endsWith(".0"));
            }
        }));
        if (documents.size() >= requestedResults) {
            return documents.subList(0, requestedResults);
        }
        return documents;
    }

    protected Set<Object> getTopicIds(List<Document> documents) {
        HashSet topicIds = Sets.newHashSet();
        for (Document document : documents) {
            topicIds.addAll((Collection)document.getField("partitions"));
        }
        return topicIds;
    }

    protected static String getTopic(Document document) {
        return (String)((List)document.getField("partitions")).get(0);
    }

    String getTopicLabel(String topicId) {
        return this.subtopicLabels.get(topicId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> loadSubtopicLabels(IResource subtopicLabelsResource) {
        HashMap labels = Maps.newHashMap();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(subtopicLabelsResource.open(), "UTF-8"));
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\\t");
                if (split.length <= 1) continue;
                labels.put(split[0], split[1]);
            }
            if (reader == null) return labels;
        }
        catch (Exception e) {
            try {
                throw ExceptionUtils.wrapAsRuntimeException(e);
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                CloseableUtils.close(reader);
                throw throwable;
            }
        }
        CloseableUtils.close((Closeable)reader);
        return labels;
    }

    private static Map<String, Integer> prepareSubtopicSizes(int[][] resultSubtopicIds) {
        HashMap map = Maps.newHashMap();
        for (int topic = 1; topic < resultSubtopicIds.length; ++topic) {
            for (int result = 1; result < resultSubtopicIds[topic].length; ++result) {
                MapUtils.increment(map, FubTestCollection.buildTopicId(topic, resultSubtopicIds[topic][result]));
            }
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<Integer, List<Document>> loadDocuments(IResource resultsResource, int[][] resultSubtopicIds) {
        HashMap documents = Maps.newHashMap();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(resultsResource.open(), "UTF-8"));
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\\t");
                String[] topicSplit = split[0].split("\\.");
                int topicId = Integer.parseInt(topicSplit[0]);
                int resultIndex = Integer.parseInt(topicSplit[1]);
                Document document = new Document();
                document.setField("url", split[1]);
                document.setField("title", split[2]);
                if (split.length > 3) {
                    document.setField("snippet", split[3]);
                }
                document.setField("partitions", ImmutableList.of((Object)FubTestCollection.buildTopicId(topicId, resultSubtopicIds[topicId].length > resultIndex ? resultSubtopicIds[topicId][resultIndex] : 0)));
                List topicList = (List)documents.get(topicId);
                if (topicList == null) {
                    topicList = Lists.newArrayList();
                    documents.put(topicId, topicList);
                }
                topicList.add(document);
            }
            if (reader == null) return documents;
        }
        catch (Exception e) {
            try {
                throw ExceptionUtils.wrapAsRuntimeException(e);
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                CloseableUtils.close(reader);
                throw throwable;
            }
        }
        CloseableUtils.close((Closeable)reader);
        return documents;
    }

    private static String buildTopicId(int topic, int subtopic) {
        return topic + "." + subtopic;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[][] loadSubtopicMapping(IResource resultsMappingResource) {
        HashMap topics;
        block10: {
            topics = Maps.newHashMap();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(resultsMappingResource.open(), "UTF-8"));
                reader.readLine();
                while ((line = reader.readLine()) != null) {
                    String[] split = line.split("[\\t.]");
                    int topicId = Integer.parseInt(split[0]);
                    int subtopicId = Integer.parseInt(split[1]);
                    int resultId = Integer.parseInt(split[3]);
                    Map topicMap = (Map)topics.get(topicId);
                    if (topicMap == null) {
                        topicMap = Maps.newHashMap();
                        topics.put(topicId, topicMap);
                    }
                    topicMap.put(resultId, subtopicId);
                }
                if (reader == null) break block10;
            }
            catch (Exception e) {
                try {
                    throw ExceptionUtils.wrapAsRuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        CloseableUtils.close(reader);
                    }
                    throw throwable;
                }
            }
            CloseableUtils.close((Closeable)reader);
        }
        this.topicCount = topics.size();
        int[][] resultSubtopicIds = new int[topics.size() + 1][];
        int topic = 1;
        while (topic < resultSubtopicIds.length) {
            Map results = (Map)topics.get(topic);
            resultSubtopicIds[topic] = new int[(Integer)Collections.max(results.keySet()) + 1];
            for (int result = 1; result < resultSubtopicIds[topic].length; ++result) {
                Integer subtopic = (Integer)results.get(result);
                if (subtopic == null) continue;
                resultSubtopicIds[topic][result] = subtopic;
            }
            ++topic;
        }
        return resultSubtopicIds;
    }
}

