/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.lucene.IFieldMapper;
import org.carrot2.source.lucene.PlainTextFormatter;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.attribute.constraint.IntRange;

@Bindable
public class SimpleFieldMapper
implements IFieldMapper {
    static final String INDEX_FIELD_MAPPING = "Index field mapping";
    static final String HIGHLIGHTER = "Highlighter";
    @Input
    @Attribute
    @Init
    @Processing
    @Internal(configuration=true)
    @Label(value="Document title field")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Index field mapping")
    public String titleField;
    @Input
    @Attribute
    @Init
    @Processing
    @Internal(configuration=true)
    @Label(value="Document content field")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Index field mapping")
    public String contentField;
    @Input
    @Attribute
    @Init
    @Processing
    @Internal(configuration=true)
    @Label(value="Document URL field")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Index field mapping")
    public String urlField;
    @Input
    @Attribute
    @Init
    @Processing
    @Internal(configuration=true)
    @Label(value="Search fields")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Index field mapping")
    public List<String> searchFields;
    @Input
    @Attribute
    @Init
    @Processing
    @ImplementingClasses(classes={PlainTextFormatter.class, SimpleHTMLFormatter.class}, strict=false)
    @Label(value="Formatter")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Highlighter")
    public Formatter formatter = new PlainTextFormatter();
    @Input
    @Attribute
    @Init
    @Processing
    @IntRange(min=1)
    @Label(value="Context fragments")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Highlighter")
    public int contextFragments = 3;
    @Input
    @Attribute
    @Init
    @Processing
    @Label(value="Join string")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Highlighter")
    public String fragmentJoin = "...";
    private Highlighter highlighter;
    private Query query;

    @Override
    public String[] getSearchFields() {
        if (this.searchFields == null || this.searchFields.size() == 0) {
            ArrayList<String> fields = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)this.titleField)) {
                fields.add(this.titleField);
            }
            if (!StringUtils.isEmpty((String)this.contentField)) {
                fields.add(this.contentField);
            }
            return fields.toArray(new String[fields.size()]);
        }
        return this.searchFields.toArray(new String[this.searchFields.size()]);
    }

    @Override
    public void map(Query luceneQuery, Analyzer analyzer, org.apache.lucene.document.Document luceneDoc, Document doc) {
        String value;
        if (luceneQuery != this.query) {
            this.query = luceneQuery;
            this.resetHighlighter();
        }
        if ((value = this.fieldValue(this.titleField, luceneDoc)) != null) {
            doc.setField("title", value);
        }
        if ((value = this.fieldValue(this.urlField, luceneDoc)) != null) {
            doc.setField("url", value);
        }
        if ((value = this.fieldValue(this.contentField, luceneDoc)) != null) {
            try {
                Object[] fragments;
                String summary = this.highlighter != null ? ((fragments = this.highlighter.getBestFragments(analyzer, this.contentField, value, this.contextFragments)).length > 0 ? StringUtils.join((Object[])fragments, (String)this.fragmentJoin) : value) : value;
                doc.setField("snippet", summary);
            }
            catch (IOException e) {
                throw ExceptionUtils.wrapAsRuntimeException(e);
            }
            catch (InvalidTokenOffsetsException e) {
                throw ExceptionUtils.wrapAsRuntimeException(e);
            }
        }
    }

    private String fieldValue(String fieldName, org.apache.lucene.document.Document doc) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        StringBuilder builder = null;
        for (Fieldable field : doc.getFields()) {
            if (!field.name().equals(fieldName) || field.isBinary()) continue;
            if (builder == null) {
                builder = new StringBuilder();
            }
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(field.stringValue());
        }
        return builder == null ? null : builder.toString();
    }

    private void resetHighlighter() {
        if (this.formatter != null) {
            this.highlighter = new Highlighter(this.formatter, (Scorer)new QueryScorer(this.query));
            this.highlighter.setEncoder((Encoder)new DefaultEncoder());
        } else {
            this.highlighter = null;
        }
    }
}

