/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.microsoft;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.microsoft.AdultOption;
import org.carrot2.source.microsoft.MarketOption;
import org.carrot2.source.microsoft.SourceType;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.NotBlank;
import org.carrot2.util.httpclient.HttpUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.NamespaceList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable(prefix="Bing3DocumentSource", inherit={CommonAttributes.class})
public abstract class Bing3DocumentSource
extends MultipageSearchEngine {
    public static final String SYSPROP_BING3_API = "bing3.key";
    private static final String SERVICE_URI = "https://api.datamarket.azure.com/Bing/Search";
    private static final Logger logger = LoggerFactory.getLogger(Bing3DocumentSource.class);
    private List<Header> HTTP_HEADERS = Arrays.asList(new Header[0]);
    protected static final int MAX_CONCURRENT_THREADS = 10;
    private static final EnumMap<SourceType, String> TYPE_URI_SUFFIXES;
    private static final int BING_TIMEOUT;
    @Init
    @Processing
    @Input
    @Attribute
    @Label(value="Application API key")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    @Required
    @NotBlank
    public String appid = System.getProperty("bing3.key");
    @Input
    @Processing
    @Attribute
    @Required
    @Label(value="Market")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Filtering")
    public MarketOption market = MarketOption.ENGLISH_UNITED_STATES;
    @Processing
    @Input
    @Attribute
    @Label(value="Safe search")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Filtering")
    public AdultOption adult;
    @Processing
    @Input
    @Attribute
    @Label(value="Latitude hint")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Filtering")
    public Double latitude;
    @Processing
    @Input
    @Attribute
    @Label(value="Longitude hint")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Filtering")
    public Double longitude;
    private final SourceType sourceType;

    public Bing3DocumentSource(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    protected void process(MultipageSearchEngineMetadata metadata, ExecutorService executor) throws ProcessingException {
        if (Strings.isNullOrEmpty((String)this.appid)) {
            throw new ProcessingException("Bing API requires a key. See " + Bing3DocumentSource.class.getSimpleName() + " class documentation.");
        }
        super.process(metadata, executor);
    }

    @Override
    protected final Callable<SearchEngineResponse> createFetcher(final MultipageSearchEngine.SearchRange bucket) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(){

            @Override
            public SearchEngineResponse search() throws Exception {
                return Bing3DocumentSource.this.doSearch(Bing3DocumentSource.this.query, bucket.start, bucket.results);
            }
        };
    }

    private final SearchEngineResponse doSearch(String query, int startAt, int totalResultsRequested) throws Exception {
        ArrayList params = Lists.newArrayList();
        params.add(new BasicNameValuePair("Query", Bing3DocumentSource.stringValue(query)));
        this.addIfNotEmpty(params, "Adult", Bing3DocumentSource.stringValue((Object)this.adult));
        this.addIfNotEmpty(params, "Market", Bing3DocumentSource.stringValue(this.market.marketCode));
        if (this.latitude != null) {
            params.add(new BasicNameValuePair("Latitude", Double.toString(this.latitude)));
        }
        if (this.longitude != null) {
            params.add(new BasicNameValuePair("Longitude", Double.toString(this.longitude)));
        }
        params.add(new BasicNameValuePair("$skip", Integer.toString(startAt)));
        params.add(new BasicNameValuePair("$top", Integer.toString(totalResultsRequested)));
        this.appendSourceParams(params);
        String serviceSuffix = TYPE_URI_SUFFIXES.get((Object)this.sourceType);
        if (serviceSuffix == null) {
            throw new RuntimeException("Service suffix is null?: " + (Object)((Object)this.sourceType));
        }
        HttpUtils.Response response = HttpUtils.doGET(SERVICE_URI + serviceSuffix, params, this.HTTP_HEADERS, "", this.appid, BING_TIMEOUT);
        if (response.status == 200) {
            SearchEngineResponse ser = this.parseResponse(response.getPayloadAsStream());
            ser.metadata.put("compression", response.compression);
            if (logger.isDebugEnabled()) {
                logger.debug("Received, results: " + ser.results.size() + ", total: " + ser.getResultsTotal());
            }
            return ser;
        }
        String m = "Bing returned HTTP Error: " + response.status + ", HTTP payload: " + new String(response.payload, "iso8859-1");
        logger.warn(m);
        if (response.status == 503 && m.contains("Insufficient balance")) {
            throw new IOException("Bing API query limit depleted. See Carrot2 FAQ: http://project.carrot2.org/faq.html#bing");
        }
        throw new IOException(m);
    }

    protected void addIfNotEmpty(ArrayList<NameValuePair> params, String paramName, Object value) {
        String stringValue;
        if (value != null && !Strings.isNullOrEmpty((String)(stringValue = value.toString()))) {
            params.add((NameValuePair)new BasicNameValuePair(paramName, stringValue));
        }
    }

    @Override
    public abstract void process() throws ProcessingException;

    protected void appendSourceParams(ArrayList<NameValuePair> params) {
    }

    private SearchEngineResponse parseResponse(InputStream payloadAsStream) throws Exception {
        AtomFeed response = (AtomFeed)new Persister().read(AtomFeed.class, payloadAsStream);
        SearchEngineResponse ser = new SearchEngineResponse();
        LanguageCode langCode = this.market.toLanguageCode();
        if (response.entries != null) {
            for (AtomEntry entry : response.entries) {
                Document doc;
                if (entry == null || entry.content == null || entry.content.properties == null) continue;
                EntryProperties p = entry.content.properties;
                switch (this.sourceType) {
                    case IMAGE: {
                        doc = new Document(p.title, p.description, p.sourceUrl);
                        break;
                    }
                    case NEWS: 
                    case WEB: {
                        doc = new Document(p.title, p.description, p.url);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                doc.setLanguage(langCode);
                if (p.displayUrl != null) {
                    doc.setField("click-url", p.displayUrl);
                }
                if (p.source != null) {
                    doc.setField("sources", Arrays.asList(p.source));
                }
                if (p.thumbnail != null && p.thumbnail.mediaUrl != null) {
                    doc.setField("thumbnail-url", p.thumbnail.mediaUrl);
                }
                ser.results.add(doc);
            }
        }
        return ser;
    }

    protected static String stringValue(Object v) {
        if (v == null || v.toString().trim().isEmpty()) {
            return null;
        }
        return "'" + v + "'";
    }

    static {
        BING_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(10L);
        TYPE_URI_SUFFIXES = Maps.newEnumMap(SourceType.class);
        TYPE_URI_SUFFIXES.put(SourceType.WEB, "/Web");
        TYPE_URI_SUFFIXES.put(SourceType.IMAGE, "/Image");
        TYPE_URI_SUFFIXES.put(SourceType.NEWS, "/News");
    }

    @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
    @Root(name="Thumbnail", strict=false)
    public static class Thumbnail {
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="MediaUrl", required=false)
        public String mediaUrl;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Width", required=false)
        public int width;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Height", required=false)
        public int height;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="ContentType", required=false)
        public String contentType;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="FileSize", required=false)
        public long fileSize;
    }

    @Root(strict=false)
    public static class EntryProperties {
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Title", required=false)
        public String title;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Description", required=false)
        public String description;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="DisplayUrl", required=false)
        public String displayUrl;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Url", required=false)
        public String url;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Source", required=false)
        public String source;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="MediaUrl", required=false)
        public String mediaUrl;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="SourceUrl", required=false)
        public String sourceUrl;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Thumbnail", required=false)
        public Thumbnail thumbnail;
    }

    @Root(strict=false)
    public static class ContentEntry {
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices/metadata")
        @Element(name="properties", required=false)
        public EntryProperties properties;
    }

    @Root(strict=false)
    public static class AtomEntry {
        @Element(name="id", required=true)
        public String id;
        @Element(name="content", required=false)
        public ContentEntry content;
    }

    @Root(name="feed", strict=false)
    @NamespaceList(value={@Namespace(reference="http://www.w3.org/2005/Atom"), @Namespace(prefix="m", reference="http://schemas.microsoft.com/ado/2007/08/dataservices/metadata"), @Namespace(prefix="d", reference="http://schemas.microsoft.com/ado/2007/08/dataservices"), @Namespace(prefix="base", reference="https://api.datamarket.azure.com/Data.ashx/Bing/Search/Web")})
    public static class AtomFeed {
        @ElementList(inline=true, entry="entry", required=false, type=AtomEntry.class)
        public List<AtomEntry> entries;
    }
}

