/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.microsoft;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.MultipageSearchEngineDescriptor;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.source.microsoft.AdultOption;
import org.carrot2.source.microsoft.MarketOption;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class Bing3DocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.microsoft.Bing3DocumentSource";
    public final String prefix = "Bing3DocumentSource";
    public final String title = "A base <code>IDocumentSource</code> sending requests to Bing Search API in Windows Azure Marketplace";
    public final String label = "";
    public final String description = "We model this into separate subclasses, specific to a particular request type (web, image, news). <p>Important: there are limits for free use of the above API (beyond which it is a paid service).";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "Bing3DocumentSource";
    }

    public String getTitle() {
        return "A base <code>IDocumentSource</code> sending requests to Bing Search API in Windows Azure Marketplace";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "We model this into separate subclasses, specific to a particular request type (web, image, news). <p>Important: there are limits for free use of the above API (beyond which it is a paid service).";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(Bing3DocumentSourceDescriptor.attributes.appid);
        ownAttrs.add(Bing3DocumentSourceDescriptor.attributes.market);
        ownAttrs.add(Bing3DocumentSourceDescriptor.attributes.adult);
        ownAttrs.add(Bing3DocumentSourceDescriptor.attributes.latitude);
        ownAttrs.add(Bing3DocumentSourceDescriptor.attributes.longitude);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(Bing3DocumentSourceDescriptor.attributes.appid);
        allAttrs.add(Bing3DocumentSourceDescriptor.attributes.market);
        allAttrs.add(Bing3DocumentSourceDescriptor.attributes.adult);
        allAttrs.add(Bing3DocumentSourceDescriptor.attributes.latitude);
        allAttrs.add(Bing3DocumentSourceDescriptor.attributes.longitude);
        allAttrs.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.start);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.results);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.query);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.documents);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.compressed);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder
    extends MultipageSearchEngineDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder appid(String value) {
            this.map.put("Bing3DocumentSource.appid", value);
            return this;
        }

        public AttributeBuilder market(MarketOption value) {
            this.map.put("Bing3DocumentSource.market", (Object)value);
            return this;
        }

        public AttributeBuilder market(Class<? extends MarketOption> clazz) {
            this.map.put("Bing3DocumentSource.market", clazz);
            return this;
        }

        public AttributeBuilder adult(AdultOption value) {
            this.map.put("Bing3DocumentSource.adult", (Object)value);
            return this;
        }

        public AttributeBuilder adult(Class<? extends AdultOption> clazz) {
            this.map.put("Bing3DocumentSource.adult", clazz);
            return this;
        }

        public AttributeBuilder latitude(Double value) {
            this.map.put("Bing3DocumentSource.latitude", value);
            return this;
        }

        public AttributeBuilder longitude(Double value) {
            this.map.put("Bing3DocumentSource.longitude", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo appid = new AttributeInfo("Bing3DocumentSource.appid", "org.carrot2.source.microsoft.Bing3DocumentSource", "appid", "Microsoft-assigned application ID for querying the API. Please <strong>generate\nyour own ID</strong> for production deployments and branches off the Carrot2.org's\ncode. See <a href=\"https://datamarket.azure.com/dataset/5ba839f1-12ce-4cce-bf57-a49d98d29a44\">http://goo.gl/usVXW</a>\nfor more.\n\n<p>By default takes the system property's value under key: <code>bing3.key</code>.</p>", "Application API key", "Microsoft-assigned application ID for querying the API", "Please <strong>generate your own ID</strong> for production deployments and branches off the Carrot2.org's code. See <a href=\"https://datamarket.azure.com/dataset/5ba839f1-12ce-4cce-bf57-a49d98d29a44\">http://goo.gl/usVXW</a> for more. <p>By default takes the system property's value under key: <code>bing3.key</code>.</p>", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo market = new AttributeInfo("Bing3DocumentSource.market", "org.carrot2.source.microsoft.Bing3DocumentSource", "market", "Language and country/region information for the request.", "Market", "Language and country/region information for the request", null, "Filtering", AttributeLevel.BASIC, null);
        public final AttributeInfo adult = new AttributeInfo("Bing3DocumentSource.adult", "org.carrot2.source.microsoft.Bing3DocumentSource", "adult", "Adult search restriction (porn filter).", "Safe search", "Adult search restriction (porn filter)", null, "Filtering", AttributeLevel.MEDIUM, null);
        public final AttributeInfo latitude = new AttributeInfo("Bing3DocumentSource.latitude", "org.carrot2.source.microsoft.Bing3DocumentSource", "latitude", "Latitude (north/south coordinate). Valid input values range from \u201390 to 90.", "Latitude hint", "Latitude (north/south coordinate)", "Valid input values range from \u201390 to 90.", "Filtering", AttributeLevel.MEDIUM, null);
        public final AttributeInfo longitude = new AttributeInfo("Bing3DocumentSource.longitude", "org.carrot2.source.microsoft.Bing3DocumentSource", "longitude", "Longitude (east/west coordinate). Valid input values range from \u2013180 to 180.", "Longitude hint", "Longitude (east/west coordinate)", "Valid input values range from \u2013180 to 180.", "Filtering", AttributeLevel.MEDIUM, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends MultipageSearchEngineDescriptor.Keys {
        public static final String APPID = "Bing3DocumentSource.appid";
        public static final String MARKET = "Bing3DocumentSource.market";
        public static final String ADULT = "Bing3DocumentSource.adult";
        public static final String LATITUDE = "Bing3DocumentSource.latitude";
        public static final String LONGITUDE = "Bing3DocumentSource.longitude";

        protected Keys() {
        }
    }
}

