/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.microsoft;

import com.google.common.base.Strings;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.microsoft.Bing3DocumentSource;
import org.carrot2.source.microsoft.SourceType;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="Bing3WebDocumentSource")
public class Bing3WebDocumentSource
extends Bing3DocumentSource {
    static final MultipageSearchEngineMetadata metadata = new MultipageSearchEngineMetadata(50, 950);
    @Processing
    @Input
    @Attribute
    @Label(value="Site restriction")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Filtering")
    public String site;

    public Bing3WebDocumentSource() {
        super(SourceType.WEB);
    }

    @Override
    public void process() throws ProcessingException {
        if (!Strings.isNullOrEmpty((String)this.site)) {
            this.query = Strings.nullToEmpty((String)this.query) + " site:" + this.site;
        }
        super.process(metadata, this.getSharedExecutor(10, this.getClass()));
    }
}

