/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.microsoft;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.carrot2.core.LanguageCode;

public enum MarketOption {
    ARABIC_ARABIA("ar-XA", "Arabic \u2013 Arabia"),
    BULGARIAN_BULGARIA("bg-BG", "Bulgarian \u2013 Bulgaria"),
    CHINESE_CHINA("zh-CN", "Chinese \u2013 China"),
    CHINESE_HONG_KONG_SAR("zh-HK", "Chinese \u2013 Hong Kong SAR"),
    CHINESE_TAIWAN("zh-TW", "Chinese \u2013 Taiwan"),
    CROATIAN_CROATIA("hr-HR", "Croatian \u2013 Croatia"),
    CZECH_CZECH_REPUBLIC("cs-CZ", "Czech \u2013 Czech Republic"),
    DANISH_DENMARK("da-DK", "Danish \u2013 Denmark"),
    DUTCH_BELGIUM("nl-BE", "Dutch \u2013 Belgium"),
    DUTCH_NETHERLANDS("nl-NL", "Dutch \u2013 Netherlands"),
    ENGLISH_AUSTRALIA("en-AU", "English \u2013 Australia"),
    ENGLISH_ARABIA("en-XA", "English \u2013 Arabia"),
    ENGLISH_CANADA("en-CA", "English \u2013 Canada"),
    ENGLISH_INDIA("en-IN", "English \u2013 India"),
    ENGLISH_INDONESIA("en-ID", "English \u2013 Indonesia"),
    ENGLISH_IRELAND("en-IE", "English \u2013 Ireland"),
    ENGLISH_MALAYSIA("en-MY", "English \u2013 Malaysia"),
    ENGLISH_NEW_ZEALAND("en-NZ", "English \u2013 New Zealand"),
    ENGLISH_PHILIPPINES("en-PH", "English \u2013 Philippines"),
    ENGLISH_SINGAPORE("en-SG", "English \u2013 Singapore"),
    ENGLISH_SOUTH_AFRICA("en-ZA", "English \u2013 South Africa"),
    ENGLISH_UNITED_KINGDOM("en-GB", "English \u2013 United Kingdom"),
    ENGLISH_UNITED_STATES("en-US", "English \u2013 United States"),
    ESTONIAN_ESTONIA("et-EE", "Estonian \u2013 Estonia"),
    FINNISH_FINLAND("fi-FI", "Finnish \u2013 Finland"),
    FRENCH_BELGIUM("fr-BE", "French \u2013 Belgium"),
    FRENCH_FRANCE("fr-FR", "French \u2013 France"),
    FRENCH_CANADA("fr-CA", "French \u2013 Canada"),
    FRENCH_SWITZERLAND("fr-CH", "French \u2013 Switzerland"),
    GERMAN_AUSTRIA("de-AT", "German \u2013 Austria"),
    GERMAN_GERMANY("de-DE", "German \u2013 Germany"),
    GERMAN_SWITZERLAND("de-CH", "German \u2013 Switzerland"),
    GREEK_GREECE("el-GR", "Greek \u2013 Greece"),
    HEBREW_ISRAEL("he-IL", "Hebrew \u2013 Israel"),
    HUNGARIAN_HUNGARY("hu-HU", "Hungarian \u2013 Hungary"),
    ITALIAN_ITALY("it-IT", "Italian \u2013 Italy"),
    JAPANESE_JAPAN("ja-JP", "Japanese \u2013 Japan"),
    KOREAN_KOREA("ko-KR", "Korean \u2013 Korea"),
    LATVIAN_LATVIA("lv-LV", "Latvian \u2013 Latvia"),
    LITHUANIAN_LITHUANIA("lt-LT", "Lithuanian \u2013 Lithuania"),
    NORWEGIAN_NORWAY("nb-NO", "Norwegian \u2013 Norway"),
    POLISH_POLAND("pl-PL", "Polish \u2013 Poland"),
    PORTUGUESE_BRAZIL("pt-BR", "Portuguese \u2013 Brazil"),
    PORTUGUESE_PORTUGAL("pt-PT", "Portuguese \u2013 Portugal"),
    ROMANIAN_ROMANIA("ro-RO", "Romanian \u2013 Romania"),
    RUSSIAN_RUSSIA("ru-RU", "Russian \u2013 Russia"),
    SLOVAK_SLOVAK_REPUBLIC("sk-SK", "Slovak \u2013 Slovak Republic"),
    SLOVENIAN_SLOVENIA("sl-SL", "Slovenian \u2013 Slovenia"),
    SPANISH_ARGENTINA("es-AR", "Spanish \u2013 Argentina"),
    SPANISH_CHILE("es-CL", "Spanish \u2013 Chile"),
    SPANISH_LATIN_AMERICA("es-XL", "Spanish \u2013 Latin America"),
    SPANISH_MEXICO("es-MX", "Spanish \u2013 Mexico"),
    SPANISH_SPAIN("es-ES", "Spanish \u2013 Spain"),
    SPANISH_UNITED_STATES("es-US", "Spanish \u2013 United States"),
    SWEDISH_SWEDEN("sv-SE", "Swedish \u2013 Sweden"),
    THAI_THAILAND("th-TH", "Thai \u2013 Thailand"),
    TURKISH_TURKEY("tr-TR", "Turkish \u2013 Turkey"),
    UKRAINIAN_UKRAINE("uk-UA", "Ukrainian \u2013 Ukraine");

    public static final Map<MarketOption, LanguageCode> TO_LANGUAGE_CODE;
    public final String marketCode;
    public final String description;

    private MarketOption(String cultureInfo, String description) {
        this.marketCode = cultureInfo;
        this.description = description;
    }

    public String toString() {
        return this.description;
    }

    public LanguageCode toLanguageCode() {
        return TO_LANGUAGE_CODE.get((Object)this);
    }

    static {
        EnumMap map = Maps.newEnumMap(MarketOption.class);
        map.put(ARABIC_ARABIA, LanguageCode.ARABIC);
        map.put(CHINESE_CHINA, LanguageCode.CHINESE_SIMPLIFIED);
        map.put(CHINESE_HONG_KONG_SAR, LanguageCode.CHINESE_SIMPLIFIED);
        map.put(CHINESE_TAIWAN, LanguageCode.CHINESE_SIMPLIFIED);
        map.put(DANISH_DENMARK, LanguageCode.DANISH);
        map.put(DUTCH_BELGIUM, LanguageCode.DUTCH);
        map.put(DUTCH_NETHERLANDS, LanguageCode.DUTCH);
        map.put(ENGLISH_AUSTRALIA, LanguageCode.ENGLISH);
        map.put(ENGLISH_ARABIA, LanguageCode.ENGLISH);
        map.put(ENGLISH_CANADA, LanguageCode.ENGLISH);
        map.put(ENGLISH_INDIA, LanguageCode.ENGLISH);
        map.put(ENGLISH_INDONESIA, LanguageCode.ENGLISH);
        map.put(ENGLISH_IRELAND, LanguageCode.ENGLISH);
        map.put(ENGLISH_MALAYSIA, LanguageCode.ENGLISH);
        map.put(ENGLISH_NEW_ZEALAND, LanguageCode.ENGLISH);
        map.put(ENGLISH_PHILIPPINES, LanguageCode.ENGLISH);
        map.put(ENGLISH_SOUTH_AFRICA, LanguageCode.ENGLISH);
        map.put(ENGLISH_UNITED_KINGDOM, LanguageCode.ENGLISH);
        map.put(ENGLISH_UNITED_STATES, LanguageCode.ENGLISH);
        map.put(FINNISH_FINLAND, LanguageCode.FINNISH);
        map.put(FRENCH_BELGIUM, LanguageCode.FRENCH);
        map.put(FRENCH_FRANCE, LanguageCode.FRENCH);
        map.put(FRENCH_CANADA, LanguageCode.FRENCH);
        map.put(FRENCH_SWITZERLAND, LanguageCode.FRENCH);
        map.put(GERMAN_AUSTRIA, LanguageCode.GERMAN);
        map.put(GERMAN_GERMANY, LanguageCode.GERMAN);
        map.put(GERMAN_SWITZERLAND, LanguageCode.GERMAN);
        map.put(HUNGARIAN_HUNGARY, LanguageCode.HUNGARIAN);
        map.put(ITALIAN_ITALY, LanguageCode.ITALIAN);
        map.put(KOREAN_KOREA, LanguageCode.KOREAN);
        map.put(NORWEGIAN_NORWAY, LanguageCode.NORWEGIAN);
        map.put(POLISH_POLAND, LanguageCode.POLISH);
        map.put(PORTUGUESE_BRAZIL, LanguageCode.PORTUGUESE);
        map.put(PORTUGUESE_PORTUGAL, LanguageCode.PORTUGUESE);
        map.put(ROMANIAN_ROMANIA, LanguageCode.ROMANIAN);
        map.put(RUSSIAN_RUSSIA, LanguageCode.RUSSIAN);
        map.put(SPANISH_ARGENTINA, LanguageCode.SPANISH);
        map.put(SPANISH_CHILE, LanguageCode.SPANISH);
        map.put(SPANISH_LATIN_AMERICA, LanguageCode.SPANISH);
        map.put(SPANISH_MEXICO, LanguageCode.SPANISH);
        map.put(SPANISH_SPAIN, LanguageCode.SPANISH);
        map.put(SPANISH_UNITED_STATES, LanguageCode.SPANISH);
        map.put(SWEDISH_SWEDEN, LanguageCode.SWEDISH);
        map.put(TURKISH_TURKEY, LanguageCode.TURKISH);
        map.put(THAI_THAILAND, LanguageCode.THAI);
        TO_LANGUAGE_CODE = Collections.unmodifiableMap(map);
    }
}

