/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.pubmed;

import java.io.IOException;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.SimpleSearchEngine;
import org.carrot2.source.pubmed.PubMedFetchHandler;
import org.carrot2.source.pubmed.PubMedSearchHandler;
import org.carrot2.util.StringUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.httpclient.HttpUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@Bindable(prefix="PubMedDocumentSource")
public class PubMedDocumentSource
extends SimpleSearchEngine {
    public static final String E_SEARCH_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi";
    public static final String E_FETCH_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi";
    public static final int PUBMED_TIMEOUT = 24000;
    @Processing
    @Input
    @Attribute
    @IntRange(min=1)
    @Internal(configuration=true)
    @Label(value="Maximum results")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Search query")
    public int maxResults = 150;

    @Override
    protected SearchEngineResponse fetchSearchResponse() throws Exception {
        return this.getPubMedAbstracts(this.getPubMedIds(this.query, this.results));
    }

    @Override
    protected void afterFetch(SearchEngineResponse response) {
        for (Document document : response.results) {
            document.setLanguage(LanguageCode.ENGLISH);
        }
    }

    private List<String> getPubMedIds(String query, int requestedResults) throws Exception {
        XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        reader.setFeature("http://xml.org/sax/features/validation", false);
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        PubMedSearchHandler searchHandler = new PubMedSearchHandler();
        reader.setContentHandler(searchHandler);
        String url = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&usehistory=n&term=" + StringUtils.urlEncodeWrapException(query, "UTF-8") + "&retmax=" + Integer.toString(Math.min(requestedResults, this.maxResults));
        HttpUtils.Response response = HttpUtils.doGET(url, null, null, null, null, 24000);
        if (response.status != 200) {
            throw new IOException("PubMed returned HTTP Error: " + response.status + ", HTTP payload: " + new String(response.payload, "iso8859-1"));
        }
        reader.parse(new InputSource(response.getPayloadAsStream()));
        return searchHandler.getPubMedPrimaryIds();
    }

    private SearchEngineResponse getPubMedAbstracts(List<String> ids) throws Exception {
        if (ids.isEmpty()) {
            return new SearchEngineResponse();
        }
        XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        reader.setFeature("http://xml.org/sax/features/validation", false);
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        PubMedFetchHandler fetchHandler = new PubMedFetchHandler();
        reader.setContentHandler(fetchHandler);
        String url = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&retmode=xml&rettype=abstract&id=" + this.getIdsString(ids);
        HttpUtils.Response response = HttpUtils.doGET(url, null, null, null, null, 24000);
        if (response.status != 200) {
            throw new IOException("PubMed returned HTTP Error: " + response.status + ", HTTP payload: " + new String(response.payload, "iso8859-1"));
        }
        reader.parse(new InputSource(response.getPayloadAsStream()));
        return fetchHandler.getResponse();
    }

    private String getIdsString(List<String> ids) {
        StringBuilder buf = new StringBuilder();
        for (String id : ids) {
            buf.append(id);
            buf.append(",");
        }
        if (buf.length() > 0) {
            return buf.substring(0, buf.length() - 1);
        }
        return "";
    }
}

