/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.solr;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.source.xml.RemoteXmlSimpleSearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class SolrDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.solr.SolrDocumentSource";
    public final String prefix = "SolrDocumentSource";
    public final String title = "Fetches documents from an instance of Solr";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "SolrDocumentSource";
    }

    public String getTitle() {
        return "Fetches documents from an instance of Solr";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(SolrDocumentSourceDescriptor.attributes.serviceUrlBase);
        ownAttrs.add(SolrDocumentSourceDescriptor.attributes.solrTitleFieldName);
        ownAttrs.add(SolrDocumentSourceDescriptor.attributes.solrSummaryFieldName);
        ownAttrs.add(SolrDocumentSourceDescriptor.attributes.solrUrlFieldName);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(SolrDocumentSourceDescriptor.attributes.serviceUrlBase);
        allAttrs.add(SolrDocumentSourceDescriptor.attributes.solrTitleFieldName);
        allAttrs.add(SolrDocumentSourceDescriptor.attributes.solrSummaryFieldName);
        allAttrs.add(SolrDocumentSourceDescriptor.attributes.solrUrlFieldName);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.start);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.results);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.query);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.documents);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.compressed);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder
    extends RemoteXmlSimpleSearchEngineBaseDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder serviceUrlBase(String value) {
            this.map.put("SolrDocumentSource.serviceUrlBase", value);
            return this;
        }

        public AttributeBuilder solrTitleFieldName(String value) {
            this.map.put("SolrDocumentSource.solrTitleFieldName", value);
            return this;
        }

        public AttributeBuilder solrSummaryFieldName(String value) {
            this.map.put("SolrDocumentSource.solrSummaryFieldName", value);
            return this;
        }

        public AttributeBuilder solrUrlFieldName(String value) {
            this.map.put("SolrDocumentSource.solrUrlFieldName", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo serviceUrlBase = new AttributeInfo("SolrDocumentSource.serviceUrlBase", "org.carrot2.source.solr.SolrDocumentSource", "serviceUrlBase", "Solr service URL base. The URL base can contain additional Solr parameters, \nfor example: <tt>http://localhost:8983/solr/select?fq=timestemp:[NOW-24HOUR TO NOW]</tt>", "Service URL", "Solr service URL base", "The URL base can contain additional Solr parameters, for example: <tt>http://localhost:8983/solr/select?fq=timestemp:[NOW-24HOUR TO NOW]</tt>", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo solrTitleFieldName = new AttributeInfo("SolrDocumentSource.solrTitleFieldName", "org.carrot2.source.solr.SolrDocumentSource", "solrTitleFieldName", "Title field name. Name of the Solr field that will provide document titles.", "Title field name", "Title field name", "Name of the Solr field that will provide document titles.", "Index field mapping", AttributeLevel.MEDIUM, null);
        public final AttributeInfo solrSummaryFieldName = new AttributeInfo("SolrDocumentSource.solrSummaryFieldName", "org.carrot2.source.solr.SolrDocumentSource", "solrSummaryFieldName", "Summary field name. Name of the Solr field that will provide document summary.", "Summary field name", "Summary field name", "Name of the Solr field that will provide document summary.", "Index field mapping", AttributeLevel.MEDIUM, null);
        public final AttributeInfo solrUrlFieldName = new AttributeInfo("SolrDocumentSource.solrUrlFieldName", "org.carrot2.source.solr.SolrDocumentSource", "solrUrlFieldName", "URL field name. Name of the Solr field that will provide document URLs.", "URL field name", "URL field name", "Name of the Solr field that will provide document URLs.", "Index field mapping", AttributeLevel.MEDIUM, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends RemoteXmlSimpleSearchEngineBaseDescriptor.Keys {
        public static final String SERVICE_URL_BASE = "SolrDocumentSource.serviceUrlBase";
        public static final String SOLR_TITLE_FIELD_NAME = "SolrDocumentSource.solrTitleFieldName";
        public static final String SOLR_SUMMARY_FIELD_NAME = "SolrDocumentSource.solrSummaryFieldName";
        public static final String SOLR_URL_FIELD_NAME = "SolrDocumentSource.solrUrlFieldName";

        protected Keys() {
        }
    }
}

