/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.xml;

import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import org.carrot2.core.Document;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.ProcessingResult;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.SimpleSearchEngine;
import org.carrot2.source.xml.XmlDocumentSourceHelper;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.resource.IResource;

@Bindable
public abstract class RemoteXmlSimpleSearchEngineBase
extends SimpleSearchEngine {
    private final XmlDocumentSourceHelper xmlDocumentSourceHelper = new XmlDocumentSourceHelper();
    private Templates toCarrot2Xslt;

    @Override
    public void init(IControllerContext context) {
        super.init(context);
        this.toCarrot2Xslt = this.xmlDocumentSourceHelper.loadXslt(this.getXsltResource());
    }

    @Override
    public void beforeProcessing() throws ProcessingException {
        super.beforeProcessing();
        if (this.toCarrot2Xslt == null) {
            throw new ProcessingException("XSLT stylesheet must not be null");
        }
    }

    @Override
    protected SearchEngineResponse fetchSearchResponse() throws Exception {
        String serviceURL = this.buildServiceUrl();
        SearchEngineResponse response = new SearchEngineResponse();
        ProcessingResult processingResult = this.xmlDocumentSourceHelper.loadProcessingResult(serviceURL, this.toCarrot2Xslt, this.getXsltParameters(), response.metadata, this.getUser(), this.getPassword());
        List<Document> documents = processingResult.getDocuments();
        if (documents != null) {
            response.results.addAll(documents);
            Map<String, Object> resultAttributes = processingResult.getAttributes();
            response.metadata.put("resultsTotal", resultAttributes.containsKey("results-total") ? resultAttributes.get("results-total") : Long.valueOf(documents.size()));
        } else {
            response.metadata.put("resultsTotal", 0L);
        }
        this.afterFetch(response);
        return response;
    }

    protected abstract IResource getXsltResource();

    protected Map<String, String> getXsltParameters() {
        return null;
    }

    protected abstract String buildServiceUrl();

    protected String getUser() {
        return null;
    }

    protected String getPassword() {
        return null;
    }
}

