/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import org.apache.lucene.analysis.ar.ArabicNormalizer;
import org.apache.lucene.analysis.ar.ArabicStemmer;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.util.MutableCharArray;

public class ArabicStemmerAdapter
implements IStemmer {
    private final ArabicStemmer delegate;
    private final ArabicNormalizer normalizer;
    private char[] buffer = new char[0];

    public ArabicStemmerAdapter() {
        this.delegate = new ArabicStemmer();
        this.normalizer = new ArabicNormalizer();
    }

    @Override
    public CharSequence stem(CharSequence word) {
        if (word.length() > this.buffer.length) {
            this.buffer = new char[word.length()];
        }
        for (int i = 0; i < word.length(); ++i) {
            this.buffer[i] = word.charAt(i);
        }
        int newLen = this.normalizer.normalize(this.buffer, word.length());
        if ((newLen = this.delegate.stem(this.buffer, newLen)) != word.length() || !this.equals(this.buffer, newLen, word)) {
            return new MutableCharArray(this.buffer, 0, newLen);
        }
        return null;
    }

    private boolean equals(char[] buffer, int len, CharSequence word) {
        assert (len == word.length());
        for (int i = 0; i < len; ++i) {
            if (buffer[i] == word.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

