/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.Evaluator;

public class VariableResolver {
    private static final Pattern DOT_PATTERN = Pattern.compile("[.]");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("[$][{](.*?)[}]");
    private static final Pattern EVALUATOR_FORMAT_PATTERN = Pattern.compile("^(\\w*?)\\((.*?)\\)$");
    private Map<String, Object> rootNamespace;
    private Map<String, Evaluator> evaluators;
    private Map<String, Resolved> cache = new WeakHashMap<String, Resolved>();
    public static final String FUNCTIONS_NAMESPACE = "dataimporter.functions.";
    public static final String FUNCTIONS_NAMESPACE_SHORT = "dih.functions.";

    public VariableResolver() {
        this.rootNamespace = new HashMap<String, Object>();
    }

    public VariableResolver(Properties defaults) {
        this.rootNamespace = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : defaults.entrySet()) {
            this.rootNamespace.put(entry.getKey().toString(), entry.getValue());
        }
    }

    public VariableResolver(Map<String, Object> defaults) {
        this.rootNamespace = new HashMap<String, Object>(defaults);
    }

    public Object resolve(String name) {
        Object r = null;
        if (name != null) {
            String[] nameParts = DOT_PATTERN.split(name);
            Map<String, Object> currentLevel = this.currentLevelMap(nameParts, this.rootNamespace, false);
            r = currentLevel.get(nameParts[nameParts.length - 1]);
            if (r == null && name.startsWith(FUNCTIONS_NAMESPACE) && name.length() > FUNCTIONS_NAMESPACE.length()) {
                return this.resolveEvaluator(FUNCTIONS_NAMESPACE, name);
            }
            if (r == null && name.startsWith(FUNCTIONS_NAMESPACE_SHORT) && name.length() > FUNCTIONS_NAMESPACE_SHORT.length()) {
                return this.resolveEvaluator(FUNCTIONS_NAMESPACE_SHORT, name);
            }
            if (r == null) {
                r = System.getProperty(name);
            }
        }
        return r == null ? "" : r;
    }

    private Object resolveEvaluator(String namespace, String name) {
        if (this.evaluators == null) {
            return "";
        }
        Matcher m = EVALUATOR_FORMAT_PATTERN.matcher(name.substring(namespace.length()));
        if (m.find()) {
            String fname = m.group(1);
            Evaluator evaluator = this.evaluators.get(fname);
            if (evaluator == null) {
                return "";
            }
            ContextImpl ctx = new ContextImpl(null, this, null, null, null, null, null);
            String g2 = m.group(2);
            return evaluator.evaluate(g2, ctx);
        }
        return "";
    }

    public String replaceTokens(String template) {
        if (template == null) {
            return null;
        }
        Resolved r = this.getResolved(template);
        if (r.startIndexes != null) {
            StringBuilder sb = new StringBuilder(template);
            for (int i = r.startIndexes.size() - 1; i >= 0; --i) {
                String replacement = this.resolve(r.variables.get(i)).toString();
                sb.replace(r.startIndexes.get(i), r.endOffsets.get(i), replacement);
            }
            return sb.toString();
        }
        return template;
    }

    private Resolved getResolved(String template) {
        Resolved r = this.cache.get(template);
        if (r == null) {
            r = new Resolved();
            Matcher m = PLACEHOLDER_PATTERN.matcher(template);
            while (m.find()) {
                String variable = m.group(1);
                r.startIndexes.add(m.start(0));
                r.endOffsets.add(m.end(0));
                r.variables.add(variable);
            }
            this.cache.put(template, r);
        }
        return r;
    }

    public List<String> getVariables(String template) {
        Resolved r = this.getResolved(template);
        if (r == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(r.variables);
    }

    public void addNamespace(String name, Map<String, Object> newMap) {
        if (newMap != null) {
            if (name != null) {
                String[] nameParts = DOT_PATTERN.split(name);
                Map<String, Object> nameResolveLevel = this.currentLevelMap(nameParts, this.rootNamespace, false);
                nameResolveLevel.put(nameParts[nameParts.length - 1], newMap);
            } else {
                for (Map.Entry<String, Object> entry : newMap.entrySet()) {
                    String[] keyParts = DOT_PATTERN.split(entry.getKey());
                    Map<String, Object> currentLevel = this.rootNamespace;
                    currentLevel = this.currentLevelMap(keyParts, currentLevel, false);
                    currentLevel.put(keyParts[keyParts.length - 1], entry.getValue());
                }
            }
        }
    }

    private Map<String, Object> currentLevelMap(String[] keyParts, Map<String, Object> currentLevel, boolean includeLastLevel) {
        int j = includeLastLevel ? keyParts.length : keyParts.length - 1;
        for (int i = 0; i < j; ++i) {
            Map nextLevel;
            Object o = currentLevel.get(keyParts[i]);
            if (o == null) {
                nextLevel = new HashMap();
                currentLevel.put(keyParts[i], nextLevel);
                currentLevel = nextLevel;
                continue;
            }
            if (o instanceof Map) {
                nextLevel = (Map)o;
                currentLevel = nextLevel;
                continue;
            }
            throw new AssertionError((Object)"Non-leaf nodes should be of type java.util.Map");
        }
        return currentLevel;
    }

    public void removeNamespace(String name) {
        this.rootNamespace.remove(name);
    }

    public void setEvaluators(Map<String, Evaluator> evaluators) {
        this.evaluators = evaluators;
    }

    class Resolved {
        List<Integer> startIndexes = new ArrayList<Integer>(2);
        List<Integer> endOffsets = new ArrayList<Integer>(2);
        List<String> variables = new ArrayList<String>(2);

        Resolved() {
        }
    }
}

