/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;

public class PDFunctionType0
extends PDFunction {
    private static final Log log = LogFactory.getLog(PDFunctionType0.class);
    private COSArray encode = null;
    private COSArray decode = null;
    private COSArray size = null;
    private int[][] samples = null;

    public PDFunctionType0(COSBase function) {
        super(function);
    }

    public int getFunctionType() {
        return 0;
    }

    public COSArray getSize() {
        if (this.size == null) {
            this.size = (COSArray)this.getDictionary().getDictionaryObject(COSName.SIZE);
        }
        return this.size;
    }

    public int[][] getSamples() {
        if (this.samples == null) {
            int arraySize = 1;
            int numberOfInputValues = this.getNumberOfInputParameters();
            int numberOfOutputValues = this.getNumberOfOutputParameters();
            COSArray sizes = this.getSize();
            for (int i = 0; i < numberOfInputValues; ++i) {
                arraySize *= sizes.getInt(i);
            }
            this.samples = new int[arraySize][this.getNumberOfOutputParameters()];
            int bitsPerSample = this.getBitsPerSample();
            int index = 0;
            int arrayIndex = 0;
            try {
                byte[] samplesArray = this.getPDStream().getByteArray();
                for (int i = 0; i < numberOfInputValues; ++i) {
                    int sizeInputValues = sizes.getInt(i);
                    for (int j = 0; j < sizeInputValues; ++j) {
                        int bitsLeft = 0;
                        int bitsToRead = bitsPerSample;
                        int currentValue = 0;
                        for (int k = 0; k < numberOfOutputValues; ++k) {
                            if (bitsLeft == 0) {
                                currentValue = (samplesArray[arrayIndex++] + 256) % 256;
                                bitsLeft = 8;
                            }
                            int value = 0;
                            while (bitsToRead > 0) {
                                int bits = Math.min(bitsToRead, bitsLeft);
                                value <<= bits;
                                int valueToAdd = currentValue >> 8 - bits;
                                value |= valueToAdd;
                                if ((bitsLeft -= bits) != 0 || (bitsToRead -= bits) <= 0) continue;
                                currentValue = (samplesArray[arrayIndex++] + 256) % 256;
                                bitsLeft = 8;
                            }
                            this.samples[index][k] = value;
                            bitsToRead = bitsPerSample;
                        }
                        ++index;
                    }
                }
            }
            catch (IOException exception) {
                log.error((Object)"IOException while reading the sample values of this function.");
            }
        }
        return this.samples;
    }

    public int getBitsPerSample() {
        return this.getDictionary().getInt(COSName.BITS_PER_SAMPLE);
    }

    public void setBitsPerSample(int bps) {
        this.getDictionary().setInt(COSName.BITS_PER_SAMPLE, bps);
    }

    private COSArray getEncodeValues() {
        if (this.encode == null) {
            this.encode = (COSArray)this.getDictionary().getDictionaryObject(COSName.ENCODE);
            if (this.encode == null) {
                this.encode = new COSArray();
                COSArray sizeValues = this.getSize();
                int sizeValuesSize = sizeValues.size();
                for (int i = 0; i < sizeValuesSize; ++i) {
                    this.encode.add(COSInteger.ZERO);
                    this.encode.add(COSInteger.get(sizeValues.getInt(i) - 1));
                }
            }
        }
        return this.encode;
    }

    private COSArray getDecodeValues() {
        if (this.decode == null) {
            this.decode = (COSArray)this.getDictionary().getDictionaryObject(COSName.DECODE);
            if (this.decode == null) {
                this.decode = this.getRangeValues();
            }
        }
        return this.decode;
    }

    public PDRange getEncodeForParameter(int paramNum) {
        PDRange retval = null;
        COSArray encodeValues = this.getEncodeValues();
        if (encodeValues != null && encodeValues.size() >= paramNum * 2 + 1) {
            retval = new PDRange(encodeValues, paramNum);
        }
        return retval;
    }

    public void setEncodeValues(COSArray encodeValues) {
        this.encode = encodeValues;
        this.getDictionary().setItem(COSName.ENCODE, (COSBase)encodeValues);
    }

    public PDRange getDecodeForParameter(int paramNum) {
        PDRange retval = null;
        COSArray decodeValues = this.getDecodeValues();
        if (decodeValues != null && decodeValues.size() >= paramNum * 2 + 1) {
            retval = new PDRange(decodeValues, paramNum);
        }
        return retval;
    }

    public void setDecodeValues(COSArray decodeValues) {
        this.decode = decodeValues;
        this.getDictionary().setItem(COSName.DECODE, (COSBase)decodeValues);
    }

    public float[] eval(float[] input) throws IOException {
        float[] sizeValues = this.getSize().toFloatArray();
        int bitsPerSample = this.getBitsPerSample();
        int numberOfInputValues = input.length;
        int numberOfOutputValues = this.getNumberOfOutputParameters();
        int[] intInputValuesPrevious = new int[numberOfInputValues];
        int[] intInputValuesNext = new int[numberOfInputValues];
        for (int i = 0; i < numberOfInputValues; ++i) {
            PDRange domain = this.getDomainForInput(i);
            PDRange encode = this.getEncodeForParameter(i);
            input[i] = this.clipToRange(input[i], domain.getMin(), domain.getMax());
            input[i] = this.interpolate(input[i], domain.getMin(), domain.getMax(), encode.getMin(), encode.getMax());
            input[i] = this.clipToRange(input[i], 0.0f, sizeValues[i] - 1.0f);
            intInputValuesPrevious[i] = (int)Math.floor(input[i]);
            intInputValuesNext[i] = (int)Math.ceil(input[i]);
        }
        float[] outputValuesPrevious = null;
        float[] outputValuesNext = null;
        outputValuesPrevious = this.getSample(intInputValuesPrevious);
        outputValuesNext = this.getSample(intInputValuesNext);
        float[] outputValues = new float[numberOfOutputValues];
        for (int i = 0; i < numberOfOutputValues; ++i) {
            PDRange range = this.getRangeForOutput(i);
            PDRange decode = this.getDecodeForParameter(i);
            outputValues[i] = (outputValuesPrevious[i] + outputValuesNext[i]) / 2.0f;
            outputValues[i] = this.interpolate(outputValues[i], 0.0f, (float)Math.pow(2.0, bitsPerSample), decode.getMin(), decode.getMax());
            outputValues[i] = this.clipToRange(outputValues[i], range.getMin(), range.getMax());
        }
        return outputValues;
    }

    private float[] getSample(int[] inputValues) {
        int[][] sampleValues = this.getSamples();
        COSArray sizes = this.getSize();
        int numberOfInputValues = this.getNumberOfInputParameters();
        int index = 0;
        int previousSize = 1;
        for (int i = 0; i < numberOfInputValues; ++i) {
            index += inputValues[i];
            previousSize *= sizes.getInt(i);
        }
        int numberOfOutputValues = this.getNumberOfOutputParameters();
        float[] result = new float[numberOfOutputValues];
        for (int i = 0; i < numberOfOutputValues; ++i) {
            result[i] = sampleValues[index][i];
        }
        return result;
    }
}

