/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.suggest;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jp.sf.fess.suggest.converter.SuggestConverter;
import org.apache.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestConverterCreator {
    private static final Logger logger = LoggerFactory.getLogger(SuggestConverterCreator.class);

    public static List<SuggestConverter> create(String val) {
        if (val == null || val.trim().length() == 0) {
            return Collections.emptyList();
        }
        try {
            Object obj = ObjectBuilder.fromJSON((String)val);
            if (obj instanceof List) {
                ArrayList<SuggestConverter> converterList = new ArrayList<SuggestConverter>();
                for (Object map : (List)obj) {
                    if (map instanceof Map) {
                        try {
                            SuggestConverter converter;
                            Map dataMap = (Map)map;
                            String className = (String)dataMap.get("class");
                            Class<SuggestConverter> clazz = Class.forName(className);
                            List constructorArgs = (List)dataMap.get("args");
                            if (constructorArgs == null || constructorArgs.isEmpty()) {
                                converter = (SuggestConverter)clazz.newInstance();
                            } else {
                                ArrayList classList = new ArrayList(constructorArgs.size());
                                for (Object arg : constructorArgs) {
                                    classList.add(arg.getClass());
                                }
                                Constructor<SuggestConverter> constructor = clazz.getConstructor(classList.toArray(new Class[constructorArgs.size()]));
                                converter = constructor.newInstance(constructorArgs.toArray(new Object[constructorArgs.size()]));
                            }
                            SuggestConverterCreator.updateInstance(dataMap, clazz, converter);
                            converterList.add(converter);
                        }
                        catch (Exception e) {
                            logger.warn("Could not create a converter.", (Throwable)e);
                        }
                        continue;
                    }
                    logger.info("Data for a converter should be an object: " + map.toString());
                }
                return converterList;
            }
            logger.info("Could not create a converter list from " + val);
        }
        catch (IOException e) {
            logger.warn("Failed to parse " + val, (Throwable)e);
        }
        return Collections.emptyList();
    }

    private static void updateInstance(Map<Object, Object> dataMap, Class<SuggestConverter> clazz, SuggestConverter converter) {
        List methodList = (List)dataMap.get("method");
        if (methodList != null && !methodList.isEmpty()) {
            for (Object obj : methodList) {
                try {
                    Class[] argClasses;
                    if (!(obj instanceof Map)) continue;
                    Map paramMap = (Map)obj;
                    String methodName = (String)paramMap.get("name");
                    List methodArgs = (List)paramMap.get("args");
                    if (methodArgs == null || methodArgs.isEmpty()) {
                        argClasses = null;
                    } else {
                        ArrayList classList = new ArrayList(methodArgs.size());
                        for (Object arg : methodArgs) {
                            classList.add(arg.getClass());
                        }
                        argClasses = classList.toArray(new Class[classList.size()]);
                    }
                    clazz.getMethod(methodName, argClasses).invoke((Object)converter, methodArgs.toArray(new Object[methodArgs.size()]));
                }
                catch (Exception e) {
                    logger.warn("Failed to invoke: " + obj.toString(), (Throwable)e);
                }
            }
        }
    }
}

