/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.dialect;

import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.SelectForUpdateType;
import org.seasar.extension.jdbc.dialect.StandardDialect;
import org.seasar.framework.util.tiger.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterbaseDialect
extends StandardDialect {
    @Override
    public String getName() {
        return "interbase";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String convertLimitSql(String sql, int offset, int limit) {
        StringBuilder buf = new StringBuilder(sql.length() + 15);
        buf.append(sql);
        if (offset > 0) {
            buf.append(" rows ");
            buf.append(offset);
            buf.append(" to ");
            buf.append(limit);
        } else {
            buf.append(" rows ");
            buf.append(limit);
        }
        return buf.toString();
    }

    @Override
    public GenerationType getDefaultGenerationType() {
        return GenerationType.SEQUENCE;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return "select RDB$GENERATOR_NAME from RDB$GENERATORS";
    }

    @Override
    public boolean supportsForUpdate(SelectForUpdateType type, boolean withTarget) {
        return type == SelectForUpdateType.NORMAL;
    }

    @Override
    public String getForUpdateString(SelectForUpdateType type, int waitSeconds, Pair<String, String> ... aliases) {
        StringBuilder buf = new StringBuilder(100);
        if (aliases.length > 0) {
            buf.append(" for update of ");
            for (Pair<String, String> alias : aliases) {
                buf.append(alias.getFirst()).append('.').append(alias.getSecond()).append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(" with lock");
        return new String(buf);
    }
}

