/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit.impl;

import java.util.List;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.log.Logger;
import org.seasar.framework.unit.DataAccessor;
import org.seasar.framework.unit.PreparationType;
import org.seasar.framework.unit.TestContext;
import org.seasar.framework.unit.TestDataPreparer;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

public class TestDataPreparerImpl
implements TestDataPreparer {
    protected static final Logger logger = Logger.getLogger(TestDataPreparerImpl.class);
    protected final List<String> testDataXlsPaths = CollectionsUtil.newArrayList();
    protected DataAccessor dataAccessor;
    @Deprecated
    protected boolean replaceDb;

    @Binding(bindingType=BindingType.MUST)
    public void setDataAccessor(DataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    @Deprecated
    public void setReplaceDb(boolean replaceDb) {
        this.replaceDb = replaceDb;
    }

    public void addTestDataXlsPath(String path) {
        this.testDataXlsPaths.add(path);
    }

    public void prepare(TestContext testContext) {
        PreparationType preparingType = this.determinePreparationType(testContext);
        String dirPath = testContext.getTestClassPackagePath();
        boolean trimString = testContext.isTrimString();
        for (String path : this.testDataXlsPaths) {
            if (ResourceUtil.isExist((String)path)) {
                this.prepare(preparingType, path, trimString);
                return;
            }
            String newPath = dirPath + "/" + path;
            if (!ResourceUtil.isExist((String)newPath)) continue;
            this.prepare(preparingType, newPath, trimString);
            return;
        }
    }

    private PreparationType determinePreparationType(TestContext testContext) {
        return this.replaceDb ? PreparationType.REPLACE : testContext.getPreparationType();
    }

    protected void prepare(PreparationType preparationType, String path, boolean trimString) {
        switch (preparationType) {
            case NONE: {
                break;
            }
            case WRITE: {
                logger.log("DSSR0103", new Object[]{path});
                this.dataAccessor.readXlsWriteDb(path, trimString);
                break;
            }
            case REPLACE: {
                logger.log("DSSR0102", new Object[]{path});
                this.dataAccessor.readXlsReplaceDb(path, trimString);
                break;
            }
            case ALL_REPLACE: {
                logger.log("DSSR0116", new Object[]{path});
                this.dataAccessor.readXlsAllReplaceDb(path, trimString);
            }
        }
    }
}

