/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uima.processor;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.uima.ae.AEProvider;
import org.apache.lucene.analysis.uima.ae.AEProviderFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.uima.processor.SolrUIMAConfiguration;
import org.apache.solr.uima.processor.UIMAToSolrMapper;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIMAUpdateRequestProcessor
extends UpdateRequestProcessor {
    private final Logger log = LoggerFactory.getLogger(UIMAUpdateRequestProcessor.class);
    SolrUIMAConfiguration solrUIMAConfiguration;
    private AEProvider aeProvider;
    private SolrCore solrCore;

    public UIMAUpdateRequestProcessor(UpdateRequestProcessor next, SolrCore solrCore, SolrUIMAConfiguration config) {
        super(next);
        this.initialize(solrCore, config);
    }

    private void initialize(SolrCore solrCore, SolrUIMAConfiguration config) {
        this.solrCore = solrCore;
        this.solrUIMAConfiguration = config;
        this.aeProvider = AEProviderFactory.getInstance().getAEProvider(solrCore.getName(), this.solrUIMAConfiguration.getAePath(), this.solrUIMAConfiguration.getRuntimeParameters());
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        String text = null;
        try {
            SolrInputDocument solrInputDocument = cmd.getSolrInputDocument();
            String[] texts = this.getTextsToAnalyze(solrInputDocument);
            for (int i = 0; i < texts.length; ++i) {
                text = texts[i];
                if (text == null || text.length() <= 0) continue;
                JCas jcas = this.processText(text);
                UIMAToSolrMapper uimaToSolrMapper = new UIMAToSolrMapper(solrInputDocument, jcas);
                Map<String, Map<String, SolrUIMAConfiguration.MapField>> typesAndFeaturesFieldsMap = this.solrUIMAConfiguration.getTypesFeaturesFieldsMapping();
                for (String typeFQN : typesAndFeaturesFieldsMap.keySet()) {
                    uimaToSolrMapper.map(typeFQN, typesAndFeaturesFieldsMap.get(typeFQN));
                }
            }
        }
        catch (Exception e) {
            String debugString;
            String optionalFieldInfo;
            SchemaField uniqueKeyField;
            String logField = this.solrUIMAConfiguration.getLogField();
            if (logField == null && (uniqueKeyField = this.solrCore.getSchema().getUniqueKeyField()) != null) {
                logField = uniqueKeyField.getName();
            }
            String string = optionalFieldInfo = logField == null ? "." : ". " + logField + "=" + (String)cmd.getSolrInputDocument().getField(logField).getValue() + ", ";
            if (text != null && text.length() > 0) {
                int len = Math.min(text.length(), 100);
                debugString = " text=\"" + text.substring(0, len) + "...\"";
            } else {
                debugString = " null text";
            }
            if (this.solrUIMAConfiguration.isIgnoreErrors()) {
                this.log.warn("skip the text processing due to " + e.getLocalizedMessage() + optionalFieldInfo + debugString);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "processing error " + e.getLocalizedMessage() + optionalFieldInfo + debugString, (Throwable)e);
        }
        super.processAdd(cmd);
    }

    private String[] getTextsToAnalyze(SolrInputDocument solrInputDocument) {
        String[] textVals;
        String[] fieldsToAnalyze = this.solrUIMAConfiguration.getFieldsToAnalyze();
        boolean merge = this.solrUIMAConfiguration.isFieldsMerging();
        if (merge) {
            StringBuilder unifiedText = new StringBuilder("");
            for (int i = 0; i < fieldsToAnalyze.length; ++i) {
                unifiedText.append(String.valueOf(solrInputDocument.getFieldValue(fieldsToAnalyze[i])));
            }
            textVals = new String[]{unifiedText.toString()};
        } else {
            textVals = new String[fieldsToAnalyze.length];
            for (int i = 0; i < fieldsToAnalyze.length; ++i) {
                textVals[i] = String.valueOf(solrInputDocument.getFieldValue(fieldsToAnalyze[i]));
            }
        }
        return textVals;
    }

    private JCas processText(String textFieldValue) throws ResourceInitializationException, AnalysisEngineProcessException {
        this.log.info(new StringBuffer("Analyzing text").toString());
        AnalysisEngine ae = this.aeProvider.getAE();
        JCas jcas = ae.newJCas();
        jcas.setDocumentText(textFieldValue);
        ae.process(jcas);
        this.log.info("Text processing completed");
        return jcas;
    }
}

