/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;

public class JapaneseTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private static final String MODE = "mode";
    private static final String USER_DICT_PATH = "userDictionary";
    private static final String USER_DICT_ENCODING = "userDictionaryEncoding";
    private static final String DISCARD_PUNCTUATION = "discardPunctuation";
    private UserDictionary userDictionary;
    private JapaneseTokenizer.Mode mode;
    private boolean discardPunctuation;

    public void inform(ResourceLoader loader) throws IOException {
        this.mode = this.getMode(this.args);
        String userDictionaryPath = (String)this.args.get(USER_DICT_PATH);
        if (userDictionaryPath != null) {
            InputStream stream = loader.openResource(userDictionaryPath);
            String encoding = (String)this.args.get(USER_DICT_ENCODING);
            if (encoding == null) {
                encoding = "UTF-8";
            }
            CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            InputStreamReader reader = new InputStreamReader(stream, decoder);
            this.userDictionary = new UserDictionary(reader);
        } else {
            this.userDictionary = null;
        }
        this.discardPunctuation = this.getBoolean(DISCARD_PUNCTUATION, true);
    }

    public Tokenizer create(Reader input) {
        return new JapaneseTokenizer(input, this.userDictionary, this.discardPunctuation, this.mode);
    }

    private JapaneseTokenizer.Mode getMode(Map<String, String> args) {
        String mode = args.get(MODE);
        if (mode != null) {
            return JapaneseTokenizer.Mode.valueOf(mode.toUpperCase(Locale.ROOT));
        }
        return JapaneseTokenizer.DEFAULT_MODE;
    }
}

