/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uima;

import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.uima.UIMAAnnotationsTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;

public class UIMAAnnotationsTokenizerFactory
extends TokenizerFactory {
    private String descriptorPath;
    private String tokenType;

    public void init(Map<String, String> args) {
        super.init(args);
        this.descriptorPath = args.get("descriptorPath");
        this.tokenType = args.get("tokenType");
        if (this.descriptorPath == null || this.tokenType == null) {
            throw new IllegalArgumentException("Both descriptorPath and tokenType are mandatory");
        }
    }

    public Tokenizer create(Reader input) {
        return new UIMAAnnotationsTokenizer(this.descriptorPath, this.tokenType, input);
    }
}

