/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uima;

import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.uima.UIMATypeAwareAnnotationsTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;

public class UIMATypeAwareAnnotationsTokenizerFactory
extends TokenizerFactory {
    private String descriptorPath;
    private String tokenType;
    private String featurePath;

    public void init(Map<String, String> args) {
        super.init(args);
        this.descriptorPath = args.get("descriptorPath");
        this.tokenType = args.get("tokenType");
        this.featurePath = args.get("featurePath");
        if (this.descriptorPath == null || this.tokenType == null || this.featurePath == null) {
            throw new IllegalArgumentException("descriptorPath, tokenType, and featurePath are mandatory");
        }
    }

    public Tokenizer create(Reader input) {
        return new UIMATypeAwareAnnotationsTokenizer(this.descriptorPath, this.tokenType, this.featurePath, input);
    }
}

