/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.dialect.impl;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.mobylet.core.Carrier;
import org.mobylet.core.device.DeviceDisplay;
import org.mobylet.core.dialect.impl.AbstractDialect;
import org.mobylet.core.gps.Geo;
import org.mobylet.core.gps.Gps;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.StringUtils;

public class MobyletAuDialect
extends AbstractDialect {
    private static final Pattern REGEX_CARRIER_MATCH = Pattern.compile("^KDDI.+");
    private static final Pattern REGEX_DEVICE_MATCH = Pattern.compile("^KDDI-[0-9a-zA-Z]+");

    @Override
    public Carrier getCarrier() {
        return Carrier.AU;
    }

    @Override
    public Pattern getCarrierMatchRegex() {
        return REGEX_CARRIER_MATCH;
    }

    @Override
    public Pattern getDeviceMatchRegex() {
        return REGEX_DEVICE_MATCH;
    }

    @Override
    public String getContentCharsetName() {
        if (this.charsetSelector.isCharsetInstalled()) {
            return "shift_jis";
        }
        return this.getCharsetName();
    }

    @Override
    public String getUid() {
        return RequestUtils.get().getHeader("X-Up-Subno");
    }

    @Override
    public String getGuid() {
        return this.getUid();
    }

    @Override
    public Gps getGps() {
        HttpServletRequest request = RequestUtils.get();
        String lat = request.getParameter("lat");
        String lon = request.getParameter("lon");
        String geoString = request.getParameter("datum");
        if (StringUtils.isEmpty(lat) || StringUtils.isEmpty(lon) || StringUtils.isEmpty(geoString)) {
            return null;
        }
        Geo geo = Geo.WGS84;
        if ("1".equals(geoString)) {
            geo = Geo.TOKYO;
        }
        Gps g = new Gps(lat, lon, geo);
        return g;
    }

    @Override
    public DeviceDisplay getDeviceDisplayByRequestHeader() {
        String dpString = RequestUtils.get().getHeader("X-UP-DEVCAP-SCREENPIXELS");
        if (StringUtils.isEmpty(dpString)) {
            return null;
        }
        try {
            String[] splitDpString = dpString.split(",");
            return new DeviceDisplay(new Integer(splitDpString[0]), new Integer(splitDpString[1]));
        }
        catch (Exception e) {
            return null;
        }
    }
}

