/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.session.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.nio.charset.Charset;
import java.util.List;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.config.MobyletSessionConfig;
import org.mobylet.core.session.InvokeType;
import org.mobylet.core.session.MobyletSessionAdapter;
import org.mobylet.core.util.HttpUtils;
import org.mobylet.core.util.SerializeUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.UrlEncoder;

public class MobyletMultiSessionAdapter
implements MobyletSessionAdapter {
    private static final Charset CHARSET = Charset.forName("utf-8");

    @Override
    public <T> T get(String key, Class<T> clazz) {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        HttpURLConnection connection = null;
        try {
            connection = this.getSessionConnection(key, InvokeType.GET, clazz);
            connection.connect();
            Object object = this.getObject(connection);
            return (T)object;
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u7ba1\u7406\u51e6\u7406\u306b\u5931\u6557 [GET]", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    public boolean invalidate(String key) {
        if (StringUtils.isEmpty(key)) {
            return false;
        }
        HttpURLConnection connection = null;
        try {
            connection = this.getSessionConnection(key, InvokeType.INVALIDATE, null);
            connection.connect();
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u7ba1\u7406\u51e6\u7406\u306b\u5931\u6557 [INVALIDATE]", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    public <T> T remove(String key, Class<T> clazz) {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        HttpURLConnection connection = null;
        try {
            connection = this.getSessionConnection(key, InvokeType.REMOVE, clazz);
            connection.connect();
            Object object = this.getObject(connection);
            return (T)object;
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u7ba1\u7406\u51e6\u7406\u306b\u5931\u6557 [REMOVE]", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public boolean set(String key, Object obj) {
        if (StringUtils.isEmpty(key)) {
            return false;
        }
        HttpURLConnection connection = null;
        try {
            connection = this.getSessionConnection(key, InvokeType.SET, obj);
            connection.connect();
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u7ba1\u7406\u51e6\u7406\u306b\u5931\u6557 [SET]", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected HttpURLConnection getSessionConnection(String key, InvokeType type, Object obj) {
        MobyletSessionConfig config = SingletonUtils.get(MobyletSessionConfig.class);
        String url = this.getBaseUrl(key);
        HttpURLConnection connection = HttpUtils.getHttpUrlConnection(url);
        try {
            connection.setRequestMethod("POST");
        }
        catch (ProtocolException e1) {
            // empty catch block
        }
        connection.setDoOutput(true);
        StringBuilder buf = new StringBuilder();
        buf.append(config.getDistribution().getParameters().getSessionKey() + "=" + UrlEncoder.encode(key, CHARSET));
        buf.append("&" + config.getDistribution().getParameters().getInvokeTypeKey() + "=" + type.name());
        if (obj != null) {
            buf.append("&" + config.getDistribution().getParameters().getObjectDataKey() + "=" + UrlEncoder.encode(SerializeUtils.serialize2Base64String(obj), CHARSET));
        }
        PrintStream printStream = null;
        try {
            OutputStream outputStream = connection.getOutputStream();
            printStream = new PrintStream(outputStream, true);
            printStream.print(buf.toString());
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u683c\u7d0d\u7528URL\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u751f\u6210\u6642\u306b\u5931\u6557 URL=" + url, e);
        }
        finally {
            if (printStream != null) {
                try {
                    printStream.close();
                }
                catch (Exception e) {}
            }
        }
        return connection;
    }

    protected Object getObject(HttpURLConnection connection) {
        int length = connection.getContentLength();
        if (length == 0) {
            return null;
        }
        InputStream inputStream = null;
        ObjectInputStream ois = null;
        try {
            inputStream = connection.getInputStream();
            ois = new ObjectInputStream(inputStream);
            Object object = ois.readObject();
            return object;
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("\u30ec\u30b9\u30dd\u30f3\u30b9\u60c5\u5831\u304b\u3089\u30bb\u30c3\u30b7\u30e7\u30f3\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u5fa9\u5143\u6642\u306bIO\u4f8b\u5916\u767a\u751f", e);
        }
        catch (ClassNotFoundException e) {
            throw new MobyletRuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u30ad\u30e3\u30b9\u30c8\u306b\u5931\u6557", e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected String getBaseUrl(String key) {
        MobyletSessionConfig config = SingletonUtils.get(MobyletSessionConfig.class);
        return config.getDistribution().getProtocol() + "://" + this.getHost(key).getHost() + config.getDistribution().getPath();
    }

    protected MobyletSessionConfig.Host getHost(String key) {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        MobyletSessionConfig config = SingletonUtils.get(MobyletSessionConfig.class);
        List<MobyletSessionConfig.Host> hosts = config.getDistribution().getReceiveHosts();
        return hosts.get(Math.abs(key.hashCode() % hosts.size()));
    }
}

