/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.io.CharArrayWriter;
import java.util.ArrayList;
import java.util.List;
import org.mobylet.core.util.StringUtils;

public class CSVSplitUtils {
    public static final String BACKSLASH = "\\";
    public static final String W_BACKSLASH = "\\\\";
    public static final String W_QUOTE = "\"";

    public static List<String> splitLine(String line) {
        ArrayList<String> splitList = new ArrayList<String>();
        if (StringUtils.isEmpty(line)) {
            return splitList;
        }
        char[] lineChars = line.toCharArray();
        boolean isInnerQuote = false;
        boolean isQuoted = false;
        int elemStartIndex = 0;
        for (int pos = 0; pos < lineChars.length; ++pos) {
            if (lineChars[pos] == ',' || pos == lineChars.length - 1) {
                if (isInnerQuote) continue;
                if (pos == elemStartIndex) {
                    splitList.add("");
                } else {
                    String elem;
                    String string = elem = pos == lineChars.length - 1 && lineChars[pos] != ',' ? new String(lineChars, elemStartIndex, pos - elemStartIndex + 1) : new String(lineChars, elemStartIndex, pos - elemStartIndex);
                    if (isQuoted && elem.contains(BACKSLASH)) {
                        CharArrayWriter caw = new CharArrayWriter(128);
                        char[] elemChars = elem.toCharArray();
                        for (int i = 0; i < elemChars.length; ++i) {
                            if (elemChars[i] == '\\' && i > 1) {
                                if (elemChars[i - 1] != '\\') continue;
                                caw.append(elemChars[i]);
                                continue;
                            }
                            if (elemChars[i] == '\"' && i > 1) {
                                if (elemChars[i - 1] != '\\') continue;
                                caw.append(elemChars[i]);
                                continue;
                            }
                            caw.append(elemChars[i]);
                        }
                        splitList.add(caw.toString());
                    } else {
                        splitList.add(elem);
                    }
                }
                elemStartIndex = pos + 1;
                isQuoted = false;
                continue;
            }
            if (lineChars[pos] != '\"') continue;
            if (pos == 0 || lineChars[pos - 1] == ',') {
                isInnerQuote = !isInnerQuote;
                isQuoted = true;
                continue;
            }
            if (pos != lineChars.length - 1 && lineChars[pos + 1] != ',') continue;
            isInnerQuote = !isInnerQuote;
        }
        return splitList;
    }

    public static String[] splitLineToArray(String line) {
        List<String> list = CSVSplitUtils.splitLine(line);
        String[] array = new String[list.size()];
        return list.toArray(array);
    }
}

