/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.codelibs.robot.db.cbean.AccessResultCB;
import org.codelibs.robot.db.cbean.UrlQueueCB;
import org.codelibs.robot.db.exbhv.AccessResultBhv;
import org.codelibs.robot.db.exbhv.UrlQueueBhv;
import org.codelibs.robot.db.exentity.AccessResult;
import org.codelibs.robot.db.exentity.UrlQueue;
import org.codelibs.robot.dbflute.cbean.PagingResultBean;
import org.codelibs.robot.service.UrlQueueService;
import org.codelibs.robot.util.LruHashMap;
import org.seasar.framework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUrlQueueServiceImpl
implements UrlQueueService {
    private static final String EMPTY_STRING = "";
    private static final Logger logger = LoggerFactory.getLogger(DBUrlQueueServiceImpl.class);
    protected static volatile Map<String, LinkedList<org.codelibs.robot.entity.UrlQueue>> URL_QUEUE_MAP = new HashMap<String, LinkedList<org.codelibs.robot.entity.UrlQueue>>();
    private static ConcurrentHashMap<String, Map<String, String>> VISITED_URL_CACHE_MAP = new ConcurrentHashMap();
    public int cacheSize = 1000;
    public int visitedUrlCacheSize = 1000;
    public int generatedUrlQueueSize = 1000;
    @Resource
    protected UrlQueueBhv urlQueueBhv;
    @Resource
    protected AccessResultBhv accessResultBhv;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<org.codelibs.robot.entity.UrlQueue> getUrlQueueList(String sessionId) {
        LinkedList<Object> urlQueueList = URL_QUEUE_MAP.get(sessionId);
        if (urlQueueList == null) {
            Map<String, LinkedList<org.codelibs.robot.entity.UrlQueue>> map = URL_QUEUE_MAP;
            synchronized (map) {
                urlQueueList = URL_QUEUE_MAP.get(sessionId);
                if (urlQueueList == null) {
                    urlQueueList = new LinkedList();
                    URL_QUEUE_MAP.put(sessionId, urlQueueList);
                }
            }
        }
        return urlQueueList;
    }

    public void updateSessionId(String oldSessionId, String newSessionId) {
        LinkedList<org.codelibs.robot.entity.UrlQueue> urlQueueList = this.getUrlQueueList(oldSessionId);
        URL_QUEUE_MAP.put(newSessionId, urlQueueList);
        URL_QUEUE_MAP.remove(oldSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String sessionId, String url) {
        LinkedList<org.codelibs.robot.entity.UrlQueue> urlQueueList;
        LinkedList<org.codelibs.robot.entity.UrlQueue> linkedList = urlQueueList = this.getUrlQueueList(sessionId);
        synchronized (linkedList) {
            UrlQueue urlQueue = new UrlQueue();
            urlQueue.setSessionId(sessionId);
            urlQueue.setMethod("GET");
            urlQueue.setUrl(url);
            urlQueue.setDepth(Integer.valueOf(0));
            urlQueue.setCreateTime(new Timestamp(new Date().getTime()));
            urlQueueList.add((org.codelibs.robot.entity.UrlQueue)urlQueue);
        }
    }

    public void insert(org.codelibs.robot.entity.UrlQueue urlQueue) {
        this.urlQueueBhv.insert((UrlQueue)urlQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String sessionId) {
        int count = this.urlQueueBhv.deleteBySessionId(sessionId);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted urls in queue: " + count);
        }
        Map<String, LinkedList<org.codelibs.robot.entity.UrlQueue>> map = URL_QUEUE_MAP;
        synchronized (map) {
            URL_QUEUE_MAP.remove(sessionId);
            VISITED_URL_CACHE_MAP.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        int count = this.urlQueueBhv.deleteAll();
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted urls in queue: " + count);
        }
        Map<String, LinkedList<org.codelibs.robot.entity.UrlQueue>> map = URL_QUEUE_MAP;
        synchronized (map) {
            URL_QUEUE_MAP.clear();
            VISITED_URL_CACHE_MAP.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerAll(String sessionId, List<org.codelibs.robot.entity.UrlQueue> newUrlQueueList) {
        LinkedList<org.codelibs.robot.entity.UrlQueue> urlQueueList;
        LinkedList<org.codelibs.robot.entity.UrlQueue> linkedList = urlQueueList = this.getUrlQueueList(sessionId);
        synchronized (linkedList) {
            ArrayList<UrlQueue> targetList = new ArrayList<UrlQueue>();
            for (org.codelibs.robot.entity.UrlQueue urlQueue : newUrlQueueList) {
                if (!this.isNewUrl(urlQueue, urlQueueList, true)) continue;
                targetList.add((UrlQueue)urlQueue);
            }
            this.urlQueueBhv.batchInsert(targetList);
        }
    }

    private Map<String, String> getVisitedUrlCache(String sessionId) {
        Map<String, String> urlMap;
        Map<String, String> visitedUrlMap = VISITED_URL_CACHE_MAP.get(sessionId);
        if (visitedUrlMap == null && (urlMap = VISITED_URL_CACHE_MAP.putIfAbsent(sessionId, visitedUrlMap = Collections.synchronizedMap(new LruHashMap(this.visitedUrlCacheSize)))) != null) {
            visitedUrlMap = urlMap;
        }
        return visitedUrlMap;
    }

    protected boolean isNewUrl(org.codelibs.robot.entity.UrlQueue urlQueue, List<org.codelibs.robot.entity.UrlQueue> urlQueueList, boolean cache) {
        String url = urlQueue.getUrl();
        if (StringUtil.isBlank((String)url)) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL is a blank: " + url);
            }
            return false;
        }
        if (cache) {
            String sessionId = urlQueue.getSessionId();
            String cacheKey = this.getCacheKey(urlQueue);
            if (this.getVisitedUrlCache(sessionId).containsKey(cacheKey)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("URL exists in a cache: " + url);
                }
                return false;
            }
            this.getVisitedUrlCache(sessionId).put(cacheKey, EMPTY_STRING);
        }
        for (org.codelibs.robot.entity.UrlQueue urlInQueue : urlQueueList) {
            if (!url.equals(urlInQueue.getUrl())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("URL exists in a queue: " + url);
            }
            return false;
        }
        UrlQueueCB cb1 = new UrlQueueCB();
        cb1.query().setUrl_Equal(url);
        cb1.query().setMetaData_Equal(urlQueue.getMetaData());
        cb1.query().setSessionId_Equal(urlQueue.getSessionId());
        int count1 = this.urlQueueBhv.selectCount(cb1);
        if (count1 > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL exists in a queue db: " + url);
            }
            return false;
        }
        AccessResultCB cb2 = new AccessResultCB();
        cb2.query().setUrl_Equal(url);
        cb2.query().setSessionId_Equal(urlQueue.getSessionId());
        int count2 = this.accessResultBhv.selectCount(cb2);
        if (count2 > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL exists in a result: " + url);
            }
            return false;
        }
        return true;
    }

    private String getCacheKey(org.codelibs.robot.entity.UrlQueue urlQueue) {
        return urlQueue.getUrl() + '\n' + urlQueue.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.codelibs.robot.entity.UrlQueue poll(String sessionId) {
        LinkedList<org.codelibs.robot.entity.UrlQueue> urlQueueList;
        LinkedList<org.codelibs.robot.entity.UrlQueue> linkedList = urlQueueList = this.getUrlQueueList(sessionId);
        synchronized (linkedList) {
            if (urlQueueList.isEmpty()) {
                UrlQueueCB cb = new UrlQueueCB();
                cb.paging(this.cacheSize, 1);
                cb.query().setSessionId_Equal(sessionId);
                PagingResultBean uqList = this.urlQueueBhv.selectPage(cb);
                if (!uqList.isEmpty()) {
                    urlQueueList.addAll((Collection<org.codelibs.robot.entity.UrlQueue>)uqList);
                    ArrayList<Long> idList = new ArrayList<Long>(this.cacheSize);
                    for (org.codelibs.robot.entity.UrlQueue uq : uqList) {
                        idList.add(uq.getId());
                    }
                    cb = new UrlQueueCB();
                    cb.query().setId_InScope(idList);
                    this.urlQueueBhv.queryDelete(cb);
                }
            }
            return urlQueueList.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSession(String sessionId) {
        LinkedList<org.codelibs.robot.entity.UrlQueue> urlQueueList;
        LinkedList<org.codelibs.robot.entity.UrlQueue> linkedList = urlQueueList = this.getUrlQueueList(sessionId);
        synchronized (linkedList) {
            ArrayList<UrlQueue> targetUrlQueueList = new ArrayList<UrlQueue>();
            for (org.codelibs.robot.entity.UrlQueue urlQueue : urlQueueList) {
                urlQueue.setId(null);
                targetUrlQueueList.add((UrlQueue)urlQueue);
            }
            this.urlQueueBhv.batchInsert(targetUrlQueueList);
            urlQueueList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visited(org.codelibs.robot.entity.UrlQueue urlQueue) {
        LinkedList<org.codelibs.robot.entity.UrlQueue> urlQueueList;
        LinkedList<org.codelibs.robot.entity.UrlQueue> linkedList = urlQueueList = this.getUrlQueueList(urlQueue.getSessionId());
        synchronized (linkedList) {
            return !this.isNewUrl(urlQueue, urlQueueList, false);
        }
    }

    public void generateUrlQueues(String previousSessionId, String sessionId) {
        AccessResultCB cb = new AccessResultCB();
        cb.query().setSessionId_Equal(previousSessionId);
        cb.query().addOrderBy_CreateTime_Asc();
        int count = this.accessResultBhv.selectCount(cb);
        ArrayList<UrlQueue> urlQueueList = new ArrayList<UrlQueue>();
        int i = 0;
        while (i * this.generatedUrlQueueSize < count) {
            urlQueueList.clear();
            cb.paging(this.generatedUrlQueueSize, i + 1);
            PagingResultBean selectPage = this.accessResultBhv.selectPage(cb);
            for (AccessResult entity : selectPage) {
                UrlQueue urlQueue = new UrlQueue();
                urlQueue.setSessionId(sessionId);
                urlQueue.setMethod(entity.getMethod());
                urlQueue.setUrl(entity.getUrl());
                urlQueue.setParentUrl(entity.getParentUrl());
                urlQueue.setDepth(Integer.valueOf(0));
                urlQueue.setLastModified(entity.getLastModified());
                urlQueue.setCreateTime(new Timestamp(new Date().getTime()));
                urlQueueList.add(urlQueue);
            }
            this.urlQueueBhv.batchInsert(urlQueueList);
            ++i;
        }
    }
}

