/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.StructurePseudoDS;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

public class RecordDatasetHelper {
    private static Logger log = LoggerFactory.getLogger(RecordDatasetHelper.class);
    protected NetcdfDataset ncfile;
    protected String obsTimeVName;
    protected String nomTimeVName;
    protected String latVName;
    protected String lonVName;
    protected String zcoordVName;
    protected String zcoordUnits;
    protected String stnIdVName;
    protected String stnIndexVName;
    protected String stnDescVName;
    protected StationHelper stationHelper;
    protected DataType stationIdType;
    protected StructureDS recordVar;
    protected Dimension obsDim;
    protected LatLonRect boundingBox;
    protected double minDate;
    protected double maxDate;
    protected DateUnit timeUnit;
    protected double altScaleFactor = 1.0;
    protected Formatter errs = null;
    protected boolean showErrors = true;
    private DateFormatter formatter;

    public RecordDatasetHelper(NetcdfDataset ncfile, String obsTimeVName, String nomTimeVName, List<VariableSimpleIF> typedDataVariables, String recDimName, Formatter errBuffer) {
        this.ncfile = ncfile;
        this.obsTimeVName = obsTimeVName;
        this.nomTimeVName = nomTimeVName;
        this.errs = errBuffer;
        if (this.ncfile.hasUnlimitedDimension()) {
            this.ncfile.sendIospMessage("AddRecordStructure");
            this.recordVar = (StructureDS)this.ncfile.getRootGroup().findVariable("record");
            this.obsDim = ncfile.getUnlimitedDimension();
        } else {
            if (recDimName == null) {
                throw new IllegalArgumentException("File <" + this.ncfile.getLocation() + "> has no unlimited dimension, specify psuedo record dimension with observationDimension global attribute.");
            }
            this.obsDim = this.ncfile.getRootGroup().findDimension(recDimName);
            this.recordVar = new StructurePseudoDS(this.ncfile, null, "record", null, this.obsDim);
        }
        List<Variable> recordMembers = ncfile.getVariables();
        for (Variable v : recordMembers) {
            if (v == this.recordVar || v.isScalar() || v.getDimension(0) != this.obsDim) continue;
            typedDataVariables.add(v);
        }
        Variable timeVar = ncfile.findVariable(obsTimeVName);
        String timeUnitString = ncfile.findAttValueIgnoreCase(timeVar, "units", "seconds since 1970-01-01");
        try {
            this.timeUnit = new DateUnit(timeUnitString);
        }
        catch (Exception e) {
            if (null != this.errs) {
                this.errs.format("Error on string = %s == %s\n", timeUnitString, e.getMessage());
            }
            try {
                this.timeUnit = new DateUnit("seconds since 1970-01-01");
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    public void setStationInfo(String stnIdVName, String stnDescVName, String stnIndexVName, StationHelper stationHelper) {
        this.stnIdVName = stnIdVName;
        this.stnDescVName = stnDescVName;
        this.stnIndexVName = stnIndexVName;
        this.stationHelper = stationHelper;
        if (stnIdVName != null) {
            Variable stationVar = this.ncfile.findVariable(stnIdVName);
            this.stationIdType = stationVar.getDataType();
        }
    }

    public void setLocationInfo(String latVName, String lonVName, String zcoordVName) {
        block4: {
            this.latVName = latVName;
            this.lonVName = lonVName;
            this.zcoordVName = zcoordVName;
            if (zcoordVName != null) {
                Variable v = this.ncfile.findVariable(zcoordVName);
                this.zcoordUnits = this.ncfile.findAttValueIgnoreCase(v, "units", null);
                if (this.zcoordUnits != null) {
                    try {
                        this.altScaleFactor = RecordDatasetHelper.getMetersConversionFactor(this.zcoordUnits);
                    }
                    catch (Exception e) {
                        if (this.errs == null) break block4;
                        this.errs.format("%s", e.getMessage());
                    }
                }
            }
        }
    }

    public void setShortNames(String latVName, String lonVName, String altVName, String obsTimeVName, String nomTimeVName) {
        this.latVName = latVName;
        this.lonVName = lonVName;
        this.zcoordVName = altVName;
        this.obsTimeVName = obsTimeVName;
        this.nomTimeVName = nomTimeVName;
    }

    protected static double getMetersConversionFactor(String unitsString) throws Exception {
        SimpleUnit unit = SimpleUnit.factoryWithExceptions(unitsString);
        return unit.convertTo(1.0, SimpleUnit.meterUnit);
    }

    public Structure getRecordVar() {
        return this.recordVar;
    }

    public int getRecordCount() {
        Dimension unlimitedDim = this.ncfile.getUnlimitedDimension();
        return unlimitedDim.getLength();
    }

    public void setTimeUnit(DateUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public DateUnit getTimeUnit() {
        return this.timeUnit;
    }

    public LatLonPoint getLocation(StructureData sdata) {
        StructureMembers members = sdata.getStructureMembers();
        double lat = sdata.convertScalarDouble(members.findMember(this.latVName));
        double lon = sdata.convertScalarDouble(members.findMember(this.lonVName));
        return new LatLonPointImpl(lat, lon);
    }

    public double getLatitude(StructureData sdata) {
        StructureMembers members = sdata.getStructureMembers();
        return sdata.convertScalarDouble(members.findMember(this.latVName));
    }

    public double getLongitude(StructureData sdata) {
        StructureMembers members = sdata.getStructureMembers();
        return sdata.convertScalarDouble(members.findMember(this.lonVName));
    }

    public double getZcoordinate(StructureData sdata) {
        StructureMembers members = sdata.getStructureMembers();
        return this.zcoordVName == null ? Double.NaN : sdata.convertScalarDouble(members.findMember(this.zcoordVName));
    }

    public String getZcoordUnits() {
        return this.zcoordUnits;
    }

    public Date getObservationTimeAsDate(StructureData sdata) {
        return this.timeUnit.makeDate(this.getObservationTime(sdata));
    }

    public double getObservationTime(StructureData sdata) {
        return this.getTime(sdata.findMember(this.obsTimeVName), sdata);
    }

    private double getTime(StructureMembers.Member timeVar, StructureData sdata) {
        if (timeVar == null) {
            return 0.0;
        }
        if (timeVar.getDataType() == DataType.CHAR || timeVar.getDataType() == DataType.STRING) {
            Date date;
            String time = sdata.getScalarString(timeVar);
            if (null == this.formatter) {
                this.formatter = new DateFormatter();
            }
            try {
                date = this.formatter.isoDateTimeFormat(time);
            }
            catch (ParseException e) {
                log.error("Cant parse date - not ISO formatted, = " + time);
                return 0.0;
            }
            return (double)date.getTime() / 1000.0;
        }
        return sdata.convertScalarDouble(timeVar);
    }

    public PointFeature factory(StationImpl s, StructureData sdata, int recno) {
        if (s == null) {
            return new RecordPointObs(sdata, recno);
        }
        return new RecordStationObs(s, sdata, recno);
    }

    class RecordStationObs
    extends RecordPointObs {
        private Station station;

        protected RecordStationObs(Station station, double obsTime, double nomTime, DateUnit timeUnit, int recno) {
            super(station, obsTime, nomTime, timeUnit, recno);
            this.station = station;
        }

        protected RecordStationObs(Station station, double obsTime, double nomTime, StructureData sdata, int recno) {
            super(recno);
            this.station = station;
            this.location = station;
            this.obsTime = obsTime;
            this.nomTime = nomTime;
            this.sdata = sdata;
        }

        protected RecordStationObs(Station station, StructureData sdata, int recno) {
            super(recno);
            this.station = station;
            this.location = station;
            this.sdata = sdata;
            StructureMembers members = sdata.getStructureMembers();
            this.obsTime = RecordDatasetHelper.this.getTime(members.findMember(RecordDatasetHelper.this.obsTimeVName), sdata);
            this.nomTime = RecordDatasetHelper.this.nomTimeVName == null ? this.obsTime : RecordDatasetHelper.this.getTime(members.findMember(RecordDatasetHelper.this.nomTimeVName), sdata);
        }

        protected RecordStationObs(StructureData sdata, int recno, boolean useId) {
            super(recno);
            this.recno = recno;
            this.sdata = sdata;
            this.timeUnit = RecordDatasetHelper.this.timeUnit;
            StructureMembers members = sdata.getStructureMembers();
            this.obsTime = RecordDatasetHelper.this.getTime(members.findMember(RecordDatasetHelper.this.obsTimeVName), sdata);
            double d = this.nomTime = RecordDatasetHelper.this.nomTimeVName == null ? this.obsTime : RecordDatasetHelper.this.getTime(members.findMember(RecordDatasetHelper.this.nomTimeVName), sdata);
            if (useId) {
                String stationId = RecordDatasetHelper.this.stationIdType == DataType.INT ? Integer.toString(sdata.getScalarInt(RecordDatasetHelper.this.stnIdVName)) : sdata.getScalarString(RecordDatasetHelper.this.stnIdVName).trim();
                this.station = RecordDatasetHelper.this.stationHelper.getStation(stationId);
                if (null != RecordDatasetHelper.this.errs) {
                    RecordDatasetHelper.this.errs.format(" cant find station id = <%s> when reading record %d\n", stationId, recno);
                }
                log.error(" cant find station id = <" + stationId + "> when reading record " + recno);
            } else {
                List<Station> stations = RecordDatasetHelper.this.stationHelper.getStations();
                int stationIndex = sdata.getScalarInt(RecordDatasetHelper.this.stnIndexVName);
                if (stationIndex < 0 || stationIndex >= stations.size()) {
                    if (null != RecordDatasetHelper.this.errs) {
                        RecordDatasetHelper.this.errs.format(" cant find station at index =%d when reading record %d\n", stationIndex, recno);
                    }
                    log.error("cant find station at index = " + stationIndex + " when reading record " + recno);
                } else {
                    this.station = stations.get(stationIndex);
                }
            }
            this.location = this.station;
        }
    }

    class RecordPointObs
    extends PointFeatureImpl {
        protected int recno;
        protected StructureData sdata;

        RecordPointObs(int recno) {
            super(RecordDatasetHelper.this.timeUnit);
            this.recno = recno;
        }

        protected RecordPointObs(EarthLocation location, double obsTime, double nomTime, DateUnit timeUnit, int recno) {
            super(location, obsTime, nomTime, timeUnit);
            this.recno = recno;
        }

        protected RecordPointObs(StructureData sdata, int recno) {
            super(RecordDatasetHelper.this.timeUnit);
            this.sdata = sdata;
            this.recno = recno;
            StructureMembers members = sdata.getStructureMembers();
            this.obsTime = RecordDatasetHelper.this.getTime(members.findMember(RecordDatasetHelper.this.obsTimeVName), sdata);
            this.nomTime = RecordDatasetHelper.this.nomTimeVName == null ? this.obsTime : RecordDatasetHelper.this.getTime(members.findMember(RecordDatasetHelper.this.nomTimeVName), sdata);
            double lat = sdata.convertScalarDouble(members.findMember(RecordDatasetHelper.this.latVName));
            double lon = sdata.convertScalarDouble(members.findMember(RecordDatasetHelper.this.lonVName));
            double alt = RecordDatasetHelper.this.zcoordVName == null ? 0.0 : RecordDatasetHelper.this.altScaleFactor * sdata.convertScalarDouble(members.findMember(RecordDatasetHelper.this.zcoordVName));
            this.location = new EarthLocationImpl(lat, lon, alt);
        }

        public String getId() {
            return Integer.toString(this.recno);
        }

        public LatLonPoint getLatLon() {
            return new LatLonPointImpl(this.location.getLatitude(), this.location.getLongitude());
        }

        @Override
        public StructureData getData() throws IOException {
            if (null == this.sdata) {
                try {
                    if (this.recno > RecordDatasetHelper.this.getRecordCount()) {
                        int n = RecordDatasetHelper.this.getRecordCount();
                        RecordDatasetHelper.this.ncfile.syncExtend();
                        log.info("RecordPointObs.getData recno=" + this.recno + " > " + n + "; after sync= " + RecordDatasetHelper.this.getRecordCount());
                    }
                    this.sdata = RecordDatasetHelper.this.recordVar.readStructure(this.recno);
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
            return this.sdata;
        }
    }
}

