/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest.service;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sf.fess.suggest.SpellChecker;
import jp.sf.fess.suggest.Suggester;
import jp.sf.fess.suggest.converter.SuggestReadingConverter;
import jp.sf.fess.suggest.entity.SpellCheckResponse;
import jp.sf.fess.suggest.entity.SuggestItem;
import jp.sf.fess.suggest.entity.SuggestResponse;
import jp.sf.fess.suggest.index.IndexUpdater;
import jp.sf.fess.suggest.server.SuggestSolrServer;
import jp.sf.fess.suggest.util.SuggestUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.util.DateUtil;
import org.codelibs.core.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestService {
    private static final Logger logger = LoggerFactory.getLogger(SuggestService.class);
    protected Suggester suggester;
    protected SpellChecker spellChecker;
    protected IndexUpdater indexUpdater;
    protected SuggestSolrServer suggestSolrServer;
    public String[] supportedFields = new String[]{"content"};
    public String labelFieldName = "label";
    public String roleFieldName = "role";
    public int defaultSearchLogExpires = 30;
    public long updateInterval = 1000L;
    protected volatile Set<String> badWords = new HashSet<String>();

    public SuggestService(Suggester suggester, SpellChecker spellChecker, SuggestSolrServer suggestSolrServer) {
        this.suggester = suggester;
        this.spellChecker = spellChecker;
        this.suggestSolrServer = suggestSolrServer;
        this.indexUpdater = new IndexUpdater(suggestSolrServer);
        this.indexUpdater.setUpdateInterval(this.updateInterval);
        this.indexUpdater.start();
    }

    public void shutdown() {
        this.indexUpdater.close();
        try {
            this.indexUpdater.join();
        }
        catch (InterruptedException e) {
            logger.info("Interrupted suggestService.");
        }
    }

    public SuggestResponse getSuggestResponse(String q, List<String> fieldNames, List<String> labels, List<String> roleList, int rows) {
        String suggestQuery = this.suggester.buildSuggestQuery(q, fieldNames, labels, roleList);
        long startTime = System.currentTimeMillis();
        QueryResponse queryResponse = null;
        SolrQuery solrQuery = new SolrQuery();
        if (StringUtil.isNotBlank((String)suggestQuery)) {
            solrQuery.setQuery(suggestQuery);
            solrQuery.setRows(Integer.valueOf(rows));
            solrQuery.addSort("boost_l", SolrQuery.ORDER.desc);
            solrQuery.addSort("count_i", SolrQuery.ORDER.desc);
            try {
                queryResponse = this.suggestSolrServer.query(solrQuery, SolrRequest.METHOD.POST);
            }
            catch (SolrServerException e) {
                logger.warn("Failed to request.", (Throwable)e);
            }
        }
        long execTime = System.currentTimeMillis() - startTime;
        SuggestResponse suggestResponse = new SuggestResponse(queryResponse, rows, q);
        suggestResponse.setExecTime(execTime);
        return suggestResponse;
    }

    public SpellCheckResponse getSpellCheckResponse(String q, List<String> fieldNames, List<String> labels, List<String> roleList, int rows) {
        String spellCheckQuery = this.spellChecker.buildSpellCheckQuery(q, fieldNames, labels, roleList);
        long startTime = System.currentTimeMillis();
        QueryResponse queryResponse = null;
        SolrQuery solrQuery = new SolrQuery();
        if (StringUtil.isNotBlank((String)spellCheckQuery)) {
            solrQuery.setQuery(spellCheckQuery);
            solrQuery.setRows(Integer.valueOf(rows));
            solrQuery.setSort("count_i", SolrQuery.ORDER.desc);
            try {
                queryResponse = this.suggestSolrServer.query(solrQuery, SolrRequest.METHOD.POST);
            }
            catch (SolrServerException e) {
                logger.warn("Failed to request.", (Throwable)e);
            }
        }
        long execTime = System.currentTimeMillis() - startTime;
        SpellCheckResponse spellCheckResponse = new SpellCheckResponse(queryResponse, rows, q);
        spellCheckResponse.setExecTime(execTime);
        return spellCheckResponse;
    }

    public void addElevateWord(String word, String reading, List<String> labels, List<String> roles, long boost) {
        SuggestItem item = new SuggestItem();
        item.setText(word);
        String readingTarget = StringUtils.isNotBlank((String)reading) ? reading : word;
        SuggestReadingConverter converter = this.suggester.getConverter();
        List<String> readings = converter.convert(readingTarget);
        for (String r : readings) {
            item.addReading(r);
        }
        for (String field : this.supportedFields) {
            item.addFieldName(field);
        }
        item.setLabels(labels);
        item.setRoles(roles);
        item.setSegment("0");
        item.setSegmentField("segment");
        item.setCount(0L);
        item.setUserBoost(boost);
        this.indexUpdater.addSuggestItem(item);
    }

    public void deleteAllElevateWords() {
        try {
            this.suggestSolrServer.deleteByQuery("segment:0");
        }
        catch (Exception e) {
            logger.warn("Failed to delete elevate words.", (Throwable)e);
        }
    }

    public void deleteBadWords() {
        for (String badWord : this.badWords) {
            try {
                this.suggestSolrServer.deleteByQuery("text_s:" + ClientUtils.escapeQueryChars((String)badWord));
            }
            catch (Exception e) {
                logger.warn("Failed to delete BadWord", (Throwable)e);
            }
        }
    }

    public void addSolrParams(String solrParams) {
        this.addSolrParams(solrParams, this.defaultSearchLogExpires);
    }

    public void addSolrParams(String solrParams, int dayForCleanup) {
        Map<String, String> paramMap = SuggestUtil.parseSolrParams(solrParams);
        String q = paramMap.get("q");
        String fq = paramMap.get("fq");
        if (StringUtils.isBlank((String)q)) {
            return;
        }
        List<String> labels = null;
        if (q != null && StringUtils.isNotBlank((String)this.labelFieldName)) {
            labels = SuggestUtil.parseQuery(q, this.labelFieldName);
        }
        List<String> roles = null;
        if (fq != null && StringUtils.isNotBlank((String)this.roleFieldName)) {
            roles = SuggestUtil.parseQuery(fq, this.roleFieldName);
        }
        StringBuilder sb = new StringBuilder(30);
        SuggestReadingConverter converter = this.suggester.getConverter();
        for (String field : this.supportedFields) {
            List<String> words = SuggestUtil.parseQuery(q, field);
            if (words.isEmpty()) continue;
            sb.setLength(0);
            SuggestItem item = new SuggestItem();
            item.addFieldName(field);
            boolean isBadWord = false;
            for (String word : words) {
                if (this.badWords.contains(word)) {
                    isBadWord = true;
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(this.normalize(word));
                List<String> readings = converter.convert(word);
                for (String reading : readings) {
                    item.addReading(reading);
                }
            }
            if (isBadWord) continue;
            item.setText(sb.toString());
            if (labels != null) {
                item.setLabels(labels);
            }
            if (roles != null) {
                item.setRoles(roles);
            }
            if (dayForCleanup >= 0) {
                String dayForCleanupStr = DateUtil.getThreadLocalDateFormat().format(new Date(this.getExpiredTimestamp(dayForCleanup)));
                item.setExpires(dayForCleanupStr);
                item.setExpiresField("expires_dt");
            }
            item.setSegment("1");
            item.setSegmentField("segment");
            this.indexUpdater.addSuggestItem(item);
        }
    }

    public void commit() {
        this.indexUpdater.commit();
    }

    public long getDocumentNum() {
        return this.getDocumentNum("*:*");
    }

    public long getContentDocumentNum() {
        return this.getDocumentNum("*:* NOT segment:1 NOT segment:0");
    }

    public long getSearchLogDocumentNum() {
        return this.getDocumentNum("segment:1");
    }

    public long getElevateDocumentNum() {
        return this.getDocumentNum("segment:0");
    }

    protected long getDocumentNum(String query) {
        QueryResponse queryResponse = null;
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(query);
            queryResponse = this.suggestSolrServer.query(solrQuery, SolrRequest.METHOD.POST);
        }
        catch (SolrServerException e) {
            return -1L;
        }
        return queryResponse.getResults().getNumFound();
    }

    public void updateBadWords(Set<String> badWords) {
        this.badWords = badWords;
    }

    public String getLabelFieldName() {
        return this.labelFieldName;
    }

    public void setLabelFieldName(String labelFieldName) {
        this.labelFieldName = labelFieldName;
    }

    public String getRoleFieldName() {
        return this.roleFieldName;
    }

    public void setRoleFieldName(String roleFieldName) {
        this.roleFieldName = roleFieldName;
    }

    protected long getExpiredTimestamp(int days) {
        return DateUtils.addDays((Date)new Date(), (int)days).getTime();
    }

    protected String normalize(String word) {
        return word.replace("*", "").replace("?", "");
    }

    public SuggestSolrServer getSuggestSolrServer() {
        return this.suggestSolrServer;
    }
}

