/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrResourceLoader;

public class CloudConfigSetService
extends ConfigSetService {
    private final ZkController zkController;

    public CloudConfigSetService(SolrResourceLoader loader, ZkController zkController) {
        super(loader);
        this.zkController = zkController;
    }

    @Override
    public SolrResourceLoader createCoreResourceLoader(CoreDescriptor cd) {
        this.zkController.createCollectionZkNode(cd.getCloudDescriptor());
        String configName = this.zkController.getZkStateReader().readConfigName(cd.getCollectionName());
        return new ZkSolrResourceLoader(cd.getInstanceDir(), configName, this.parentLoader.getClassLoader(), cd.getSubstitutableProperties(), this.zkController);
    }

    @Override
    public String configName(CoreDescriptor cd) {
        return "collection " + cd.getCloudDescriptor().getCollectionName();
    }
}

