/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.AbstractStatsValues;
import org.apache.solr.schema.SchemaField;

class NumericStatsValues
extends AbstractStatsValues<Number> {
    double sum;
    double sumOfSquares;

    public NumericStatsValues(SchemaField sf, boolean calcDistinct) {
        super(sf, calcDistinct);
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }

    @Override
    public void accumulate(int docID) {
        if (this.values.exists(docID)) {
            this.accumulate((Number)this.values.objectVal(docID), 1);
        } else {
            this.missing();
        }
    }

    @Override
    public void updateTypeSpecificStats(NamedList stv) {
        this.sum += ((Number)stv.get("sum")).doubleValue();
        this.sumOfSquares += ((Number)stv.get("sumOfSquares")).doubleValue();
    }

    @Override
    public void updateTypeSpecificStats(Number v, int count) {
        double value = v.doubleValue();
        this.sumOfSquares += value * value * (double)count;
        this.sum += value * (double)count;
    }

    @Override
    protected void updateMinMax(Number min, Number max) {
        this.min = Math.min(((Number)this.min).doubleValue(), min.doubleValue());
        this.max = Math.max(((Number)this.max).doubleValue(), max.doubleValue());
    }

    @Override
    protected void addTypeSpecificStats(NamedList<Object> res) {
        res.add("sum", (Object)this.sum);
        res.add("sumOfSquares", (Object)this.sumOfSquares);
        res.add("mean", (Object)(this.sum / (double)this.count));
        res.add("stddev", (Object)this.getStandardDeviation());
    }

    private double getStandardDeviation() {
        if ((double)this.count <= 1.0) {
            return 0.0;
        }
        return Math.sqrt(((double)this.count * this.sumOfSquares - this.sum * this.sum) / ((double)this.count * ((double)this.count - 1.0)));
    }
}

